/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.pagepanel;

import java.io.IOException;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.ace.util.Attribute;
import org.icefaces.ace.util.PassThruAttributeWriter;
import org.icefaces.ace.util.Utils;
import org.icefaces.mobi.component.pagepanel.PagePanel;
import org.icefaces.mobi.renderkit.CoreRenderer;

public class PagePanelRenderer
extends CoreRenderer {
    private static final Logger logger = Logger.getLogger(PagePanelRenderer.class.getName());

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        PagePanel pagePanel = (PagePanel)component;
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = component.getClientId(facesContext);
        writer.startElement("div", (UIComponent)pagePanel);
        writer.writeAttribute("id", (Object)(clientId + "_pgPnl"), "id");
        writer.writeAttribute("class", (Object)"mobi-pagePanel ui-widget", null);
        PassThruAttributeWriter.renderNonBooleanAttributes((ResponseWriter)writer, (UIComponent)pagePanel, (Attribute[])pagePanel.getCommonAttributeNames());
        if (pagePanel.getStyle() != null) {
            writer.writeAttribute("style", (Object)pagePanel.getStyle(), "style");
        }
        UIComponent headerFacet = pagePanel.getFacet("header");
        UIComponent bodyFacet = pagePanel.getFacet("body");
        UIComponent footerFacet = pagePanel.getFacet("footer");
        String userDefStyle = pagePanel.getStyleClass();
        if (headerFacet == null && bodyFacet == null && footerFacet == null) {
            logger.warning("PagePanel header, body and footer were not defined, no content will be rendered by this component.");
        }
        String headerClass = this.getHeaderClass(pagePanel, userDefStyle);
        String bodyClass = this.getBodyClass(pagePanel, userDefStyle, headerFacet, footerFacet);
        String footerClass = this.getFooterClass(pagePanel, userDefStyle);
        String headerFooterContentsClass = "mobi-pagePanel-ctr" + (userDefStyle != null ? " " + userDefStyle : "");
        if (headerFacet != null) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)headerClass, "class");
            writer.writeAttribute("id", (Object)(clientId + "_pgPnlHdr"), "id");
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)headerFooterContentsClass, "styleClass");
            if (headerFacet.isRendered()) {
                headerFacet.encodeAll(facesContext);
            }
            writer.endElement("div");
            writer.endElement("div");
        }
        if (bodyFacet != null) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)bodyClass, "class");
            writer.writeAttribute("id", (Object)(clientId + "_pgPnlBdy"), "id");
            if (bodyFacet.isRendered()) {
                bodyFacet.encodeAll(facesContext);
            }
            writer.endElement("div");
        }
        if (footerFacet != null) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)footerClass, "class");
            writer.writeAttribute("id", (Object)(clientId + "_pgPnlFtr"), "id");
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)headerFooterContentsClass, "styleClass");
            if (footerFacet.isRendered()) {
                footerFacet.encodeAll(facesContext);
            }
            writer.endElement("div");
            writer.endElement("div");
        }
        writer.endElement("div");
    }

    private String getFooterClass(PagePanel pagePanel, String userDefStyle) {
        return "mobi-pagePanel-footer ui-widget-content " + (Utils.getClientDescriptor().isSupportsFixedPosition() ? " ui-footer-fixed" : "") + (userDefStyle != null ? " " + userDefStyle : "");
    }

    private String getBodyClass(PagePanel pagePanel, String userDefStyle, UIComponent headerFacet, UIComponent footerFacet) {
        return "mobi-pagePanel-body ui-widget-content" + (userDefStyle != null ? " " + userDefStyle : "") + (headerFacet == null ? " mobi-pagePanel-body-noheader" : "") + (footerFacet == null ? " mobi-pagePanel-body-nofooter" : "");
    }

    private String getHeaderClass(PagePanel panel, String userDefStyle) {
        return "mobi-pagePanel-header ui-widget-header" + (Utils.getClientDescriptor().isSupportsFixedPosition() ? " ui-header-fixed" : "") + (userDefStyle != null ? " " + userDefStyle : "");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

