/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.scan;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.icefaces.impl.application.AuxUploadResourceHandler;
import org.icefaces.mobi.component.scan.Scan;
import org.icefaces.mobi.renderkit.BaseInputRenderer;
import org.icefaces.mobi.renderkit.ResponseWriterWrapper;
import org.icefaces.mobi.util.MobiJSFUtils;

public class ScanRenderer
extends BaseInputRenderer {
    private static final Logger logger = Logger.getLogger(ScanRenderer.class.getName());

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        String submittedString;
        String valueId;
        Scan scan = (Scan)uiComponent;
        String clientId = scan.getClientId();
        if (scan.isDisabled()) {
            return;
        }
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        Object submitted = requestParameterMap.get(valueId = clientId);
        if (null == submitted) {
            Map auxMap = AuxUploadResourceHandler.getAuxRequestMap();
            submitted = auxMap.get(valueId);
        }
        if (null != submitted && (submittedString = String.valueOf(submitted)) != null) {
            Object convertedValue = this.getConvertedValue(facesContext, uiComponent, submittedString);
            this.setSubmittedValue((UIComponent)scan, convertedValue);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String styleClass;
        String style;
        Scan scan = (Scan)uiComponent;
        ResponseWriterWrapper writer = new ResponseWriterWrapper(facesContext.getResponseWriter());
        String clientId = scan.getClientId();
        writer.startElement("span", scan);
        writer.writeAttribute("id", clientId);
        String oldLabel = scan.getButtonLabel();
        if (MobiJSFUtils.uploadInProgress((UIComponent)scan)) {
            scan.setButtonLabel(scan.getCaptureMessageLabel());
        }
        StringBuilder baseClass = new StringBuilder("mobi-button ui-btn-up-c");
        writer.startElement("button", scan);
        writer.writeAttribute("id", clientId + "_button");
        writer.writeAttribute("name", clientId + "_button");
        writer.writeAttribute("type", "button");
        String script = "bridgeit.scan('" + clientId + "', '', {postURL:'" + scan.getPostURL() + "', " + "cookies:{'JSESSIONID':'" + MobiJSFUtils.getSessionIdCookie(facesContext) + "'}});";
        writer.writeAttribute("onclick", script);
        boolean disabled = scan.isDisabled();
        if (disabled) {
            writer.writeAttribute("disabled", "disabled");
        }
        if ((style = scan.getStyle()) != null) {
            writer.writeAttribute("style", style);
        }
        if ((styleClass = scan.getStyleClass()) != null) {
            writer.writeAttribute("class", styleClass);
        }
        writer.writeAttribute("tabindex", scan.getTabindex());
        writer.startElement("span", scan);
        writer.writeText(scan.getButtonLabel());
        writer.endElement("span");
        writer.startElement("span", scan);
        writer.startElement("script", scan);
        writer.writeAttribute("type", "text/javascript");
        writer.writeText("new ice.mobi.button('" + clientId + "_button');");
        writer.endElement("script");
        writer.endElement("span");
        writer.endElement("button");
        writer.endElement("span");
        scan.setButtonLabel(oldLabel);
    }
}

