/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.thumbnail;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.icefaces.mobi.component.thumbnail.Thumbnail;
import org.icefaces.mobi.util.MobiJSFUtils;
import org.icefaces.util.ClientDescriptor;

public class ThumbnailRenderer
extends Renderer {
    private static final Logger logger = Logger.getLogger(ThumbnailRenderer.class.toString());

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Thumbnail thumbnail = (Thumbnail)uiComponent;
        String clientId = thumbnail.getClientId();
        Map requestMap = facesContext.getExternalContext().getRequestParameterMap();
        String data = (String)requestMap.get(clientId + "_data");
        thumbnail.setData(data);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UIComponent comp;
        Thumbnail thumbnail = (Thumbnail)uiComponent;
        String compId = thumbnail.getFor();
        if (compId == null && (facesContext.isProjectStage(ProjectStage.Development) || logger.isLoggable(Level.FINER))) {
            logger.warning("'for' attribute cannot be null");
        }
        if ((comp = thumbnail.findComponent(compId)) == null) {
            logger.warning("Cannot locate associated component 'for' = " + compId);
            return;
        }
        String mFor = comp.getId();
        if (null != comp) {
            mFor = comp.getClientId(facesContext);
            if (MobiJSFUtils.uploadInProgress(comp)) {
                thumbnail.setBaseClass("mobi-thumb-done");
            } else {
                thumbnail.setBaseClass("mobi-thumb");
            }
        } else if (facesContext.isProjectStage(ProjectStage.Development) || logger.isLoggable(Level.FINER)) {
            logger.finer(" Cannot find camera or camcorder component with id=" + compId);
        }
        if (null == thumbnail.getMFor()) {
            thumbnail.setMFor(mFor);
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        this.encode(thumbnail, writer, comp.getClientId(facesContext));
    }

    public void encode(Thumbnail component, ResponseWriter writer, String mFor) throws IOException {
        String clientId = component.getClientId();
        ClientDescriptor cd = component.getClient();
        if (cd.isDesktopBrowser()) {
            return;
        }
        boolean renderThumbnail = false;
        if (cd.isICEmobileContainer() || cd.isSXRegistered()) {
            renderThumbnail = true;
        }
        String thumbId = component.getMFor() + "-thumb";
        if (renderThumbnail) {
            writer.startElement("span", (UIComponent)component);
            String styleClass = component.getBaseClass();
            if (component.getStyleClass() != null) {
                styleClass = styleClass + " " + component.getStyleClass();
            }
            writer.writeAttribute("class", (Object)styleClass, null);
            String style = component.getStyle();
            if (style != null) {
                writer.writeAttribute("style", (Object)style, null);
            }
            writer.startElement("img", (UIComponent)component);
            writer.writeAttribute("width", (Object)"64", null);
            writer.writeAttribute("height", (Object)"64", null);
            writer.writeAttribute("id", (Object)thumbId, null);
            String data = component.getData();
            if (data != null) {
                writer.writeAttribute("src", (Object)data, null);
            }
            writer.endElement("img");
            writer.startElement("input", (UIComponent)component);
            writer.writeAttribute("type", (Object)"hidden", null);
            writer.writeAttribute("id", (Object)(clientId + "_data"), null);
            writer.writeAttribute("name", (Object)(clientId + "_data"), null);
            writer.endElement("input");
            writer.endElement("span");
        }
        writer.startElement("script", (UIComponent)component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("if (!window['thumbnails" + mFor + "']) window['thumbnails" + mFor + "'] = {};");
        writer.write("window['thumbnails" + mFor + "']['" + thumbId + "'] = '" + clientId + "_data';");
        writer.endElement("script");
    }
}

