/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.renderkit;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.mobi.renderkit.CoreRenderer;

public class BaseLayoutRenderer
extends CoreRenderer {
    public static final String TOUCH_START_EVENT = "ontouchstart";
    public static final String CLICK_EVENT = "onclick";

    @Override
    protected void renderChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        for (UIComponent child : uiComponent.getChildren()) {
            this.renderChild(facesContext, child);
        }
    }

    @Override
    protected void renderChild(FacesContext facesContext, UIComponent child) throws IOException {
        if (!child.isRendered()) {
            return;
        }
        child.encodeBegin(facesContext);
        if (child.getRendersChildren()) {
            child.encodeChildren(facesContext);
        } else {
            this.renderChildren(facesContext, child);
        }
        child.encodeEnd(facesContext);
    }

    protected void encodeHidden(FacesContext context, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = uiComponent.getClientId(context);
        writer.startElement("span", uiComponent);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"hidden", "type");
        writer.writeAttribute("id", (Object)(clientId + "_hidden"), "id");
        writer.writeAttribute("name", (Object)(clientId + "_hidden"), "name");
        writer.endElement("input");
        writer.endElement("span");
    }

    protected void encodeHidden(FacesContext context, UIComponent uiComponent, String value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = uiComponent.getClientId(context);
        writer.startElement("span", uiComponent);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"hidden", "type");
        writer.writeAttribute("id", (Object)(clientId + "_hidden"), "id");
        writer.writeAttribute("name", (Object)(clientId + "_hidden"), "name");
        writer.writeAttribute("value", (Object)value, "value");
        writer.endElement("input");
        writer.endElement("span");
    }

    @Override
    protected String getResourceURL(FacesContext facesContext, String value) {
        if (value.contains("/javax.faces.resource")) {
            return value;
        }
        String url = facesContext.getApplication().getViewHandler().getResourceURL(facesContext, value);
        return facesContext.getExternalContext().encodeResourceURL(url);
    }
}

