/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.renderkit;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.FacesContext;
import org.icefaces.impl.util.Base64;
import org.icefaces.impl.util.Util;

public class BridgeItResourceHandler
extends ResourceHandlerWrapper {
    private static final String DEFAULT_BRIDGEIT_JS_URI = "http://api.bridgeit.mobi/bridgeit/v1.x-latest/bridgeit.js";
    private static String BRIDGEIT_JS_URI = "org.icefaces.mobi.bridgeit.javaScriptURI";
    private static final String BRIDGEIT_API = "core/bridgeit.js";
    private static final String ICEFACES_MOBI_LIB = "icefaces.mobi";
    private static final byte[] NO_BYTES = new byte[0];
    private ResourceHandler handler;
    private Resource apiJS;
    private String uri;

    public BridgeItResourceHandler(ResourceHandler handler) {
        this.handler = handler;
        FacesContext context = FacesContext.getCurrentInstance();
        this.uri = context.getExternalContext().getInitParameter(BRIDGEIT_JS_URI);
        if (this.uri == null || this.uri.trim().length() == 0) {
            this.uri = DEFAULT_BRIDGEIT_JS_URI;
        }
    }

    public ResourceHandler getWrapped() {
        return this.handler;
    }

    public Resource createResource(String resourceName) {
        return this.createResource(resourceName, null, null);
    }

    public Resource createResource(String resourceName, String libraryName) {
        return this.createResource(resourceName, libraryName, null);
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        if (BRIDGEIT_API.equals(resourceName)) {
            if (this.apiJS == null) {
                FacesContext context = FacesContext.getCurrentInstance();
                String resolvedURI = context.getApplication().getViewHandler().getResourceURL(context, this.uri);
                this.apiJS = this.recreateResource(super.createResource(resourceName, ICEFACES_MOBI_LIB), resolvedURI);
            }
            return this.apiJS;
        }
        return super.createResource(resourceName, libraryName, contentType);
    }

    private Resource recreateResource(Resource resource, String url) {
        return new ResourceEntry(BRIDGEIT_API, url);
    }

    private class ResourceEntry
    extends Resource {
        private Date lastModified = new Date();
        private String localPath;
        private String requestPath;

        private ResourceEntry(String localPath, String requestPath) {
            this.localPath = localPath;
            this.requestPath = requestPath;
        }

        public String getLibraryName() {
            return BridgeItResourceHandler.ICEFACES_MOBI_LIB;
        }

        public String getResourceName() {
            return BridgeItResourceHandler.BRIDGEIT_API;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(NO_BYTES);
        }

        public Map<String, String> getResponseHeaders() {
            return Collections.emptyMap();
        }

        public String getContentType() {
            return "text/javascript";
        }

        public String getRequestPath() {
            return this.requestPath;
        }

        public URL getURL() {
            try {
                return FacesContext.getCurrentInstance().getExternalContext().getResource(this.localPath);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean userAgentNeedsUpdate(FacesContext context) {
            try {
                Date modifiedSince = Util.parseHTTPDate((String)((String)context.getExternalContext().getRequestHeaderMap().get("If-Modified-Since")));
                return this.lastModified.getTime() > modifiedSince.getTime() + 1000L;
            }
            catch (Throwable e) {
                return true;
            }
        }

        private String eTag() {
            return Base64.encode((String)String.valueOf(this.localPath.hashCode()));
        }
    }
}

