/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.util;

import javax.servlet.http.HttpServletRequest;
import org.icefaces.util.ClientDescriptor;

public class CSSUtils {
    public static final String CSS_COMPRESSION_POSTFIX = "-min";
    public static final String HIDDEN = "ui-screen-hidden";
    public static final String STYLECLASS_BUTTON = "mobi-button ui-btn-up-c";
    public static final String STYLECLASS_BUTTON_DISABLED = " mobi-button-dis";
    public static final String STYLECLASS_BUTTON_ATTENTION = "mobi-button-attention";
    public static final String STYLECLASS_BUTTON_IMPORTANT = "mobi-button-important";
    public static final String STYLECLASS_BUTTON_BACK = "mobi-button-back";
    public static final String STYLECLASS_DISABLED = "ui-disabled";
    public static final String STYLECLASS_COLLAPSIBLESET = "ui-collapsible-set";
    public static final String STYLECLASS_COLLAPSIBLE = "ui-collapsible";
    public static final String STYLECLASS_COLLAPSED = "ui-collapsible-collapsed";
    public static final String STYLECLASS_COLLAPSIBLEINSET = "ui-collapsible-inset";
    public static final String STYLECLASS_COLLAPSIBLEHEADING = "ui-collapsible-heading";
    public static final String STYLECLASS_COLLAPSIBLEHEADINGTOGGLE = "ui-collapsible-heading-toggle";
    public static final String STYLECLASS_COLLAPSIBLECONTENT = "ui-collapsible-content";
    public static final String STYLECLASS_BAR_A = "ui-bar-a";
    public static final String STYLECLASS_BAR_B = "ui-bar-b";
    public static final String STYLECLASS_ACTIVE = "ui-btn-active";

    public static Theme deriveTheme(String targetView, HttpServletRequest request) {
        ClientDescriptor client = ClientDescriptor.getInstance((HttpServletRequest)request);
        Theme theme = null;
        View view = View.getEnum(targetView);
        if (view == null) {
            View view2 = view = client.isHandheldBrowser() ? View.SMALL : View.LARGE;
        }
        if (client.isBlackBerry10OS()) {
            theme = Theme.BB10;
        } else if (client.isBlackBerryOS()) {
            theme = Theme.BBERRY;
        } else if (client.isAndroidOS()) {
            theme = Theme.ANDROID_LIGHT;
        } else if (client.isIOS()) {
            if (view == View.SMALL) {
                theme = Theme.IPHONE;
            } else if (view == View.LARGE) {
                theme = Theme.IPAD;
            }
        } else {
            theme = client.isIE8orLessBrowser() ? Theme.ARCHAIC : Theme.ANDROID_LIGHT;
        }
        return theme;
    }

    public static Theme deriveTheme(HttpServletRequest request) {
        return CSSUtils.deriveTheme(null, request);
    }

    public static String getThemeCSSFileName(Theme theme, boolean production) {
        return theme.fileName() + (production ? CSS_COMPRESSION_POSTFIX : "") + ".css";
    }

    public static enum View {
        LARGE,
        SMALL;


        public static View getEnum(String val) {
            if (val == null) {
                return null;
            }
            View result = null;
            try {
                result = View.valueOf(val.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return result;
        }
    }

    public static enum Theme {
        BASE,
        IPAD,
        IPHONE,
        BBERRY,
        ANDROID,
        HONEYCOMB,
        ARCHAIC,
        ANDROID_LIGHT,
        ANDROID_DARK,
        BB10,
        JQM;


        public String fileName() {
            return this.name().toLowerCase();
        }

        public static Theme getEnum(String val) {
            if (val == null) {
                return null;
            }
            Theme result = null;
            try {
                result = Theme.valueOf(val.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return result;
        }
    }
}

