/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.outputlist;

import java.io.IOException;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.icefaces.mobi.component.outputlist.OutputListItem;

public class OutputListItemRenderer
extends Renderer {
    private static final Logger logger = Logger.getLogger(OutputListItemRenderer.class.getName());

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        OutputListItem item = (OutputListItem)uiComponent;
        writer.startElement("li", null);
        writer.writeAttribute("id", (Object)clientId, "id");
        String userDefinedClass = item.getStyleClass();
        String styleClass = "mobi-list-item ui-widget-content ui-state-default";
        if (item.isGroup()) {
            styleClass = "mobi-list-item mobi-list-item-group ui-widget-header ";
            if (userDefinedClass != null) {
                styleClass = styleClass + " " + userDefinedClass;
            }
        } else if (userDefinedClass != null) {
            styleClass = styleClass + " " + userDefinedClass;
        }
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (item.getStyle() != null) {
            writer.writeAttribute("style", (Object)item.getStyle(), "style");
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"mobi-list-item-default ", null);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        OutputListItem item = (OutputListItem)uiComponent;
        ResponseWriter writer = facesContext.getResponseWriter();
        if (!item.isGroup() && item.getChildren().size() == 1 && item.getChildren().get(0) instanceof HtmlCommandLink) {
            this.writeArrowIcon(writer);
        }
        writer.endElement("div");
        writer.endElement("li");
    }

    private void writeArrowIcon(ResponseWriter writer) throws IOException {
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"icon-angle-right", null);
        writer.endElement("span");
    }
}

