/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.thumbnail;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.icefaces.mobi.component.camera.Camera;
import org.icefaces.mobi.component.thumbnail.Thumbnail;
import org.icefaces.util.ClientDescriptor;

public class ThumbnailRenderer
extends Renderer {
    private static final Logger logger = Logger.getLogger(ThumbnailRenderer.class.toString());

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UIComponent comp;
        Thumbnail thumbnail = (Thumbnail)uiComponent;
        String compId = thumbnail.getFor();
        if (compId == null && (facesContext.isProjectStage(ProjectStage.Development) || logger.isLoggable(Level.FINER))) {
            logger.warning("'for' attribute cannot be null");
        }
        if ((comp = thumbnail.findComponent(compId)) == null) {
            logger.warning("Cannot locate associated component 'for' = " + compId);
            return;
        }
        String mFor = comp.getId();
        if (null != comp) {
            mFor = comp.getClientId(facesContext);
        } else if (facesContext.isProjectStage(ProjectStage.Development) || logger.isLoggable(Level.FINER)) {
            logger.finer(" Cannot find camera component with id=" + compId);
        }
        if (null == thumbnail.getMFor()) {
            thumbnail.setMFor(mFor);
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        this.encode(thumbnail, writer, comp.getClientId(facesContext), comp);
    }

    public void encode(Thumbnail component, ResponseWriter writer, String mFor, UIComponent forComp) throws IOException {
        boolean isForCamera;
        String clientId = component.getClientId();
        ClientDescriptor cd = component.getClient();
        boolean isCam = isForCamera = forComp instanceof Camera;
        if (cd.isDesktopBrowser() && !isCam) {
            logger.info("thumbnail not being rendered");
            return;
        }
        boolean renderThumbnail = false;
        if (cd.isICEmobileContainer() || cd.isSXRegistered() || isForCamera) {
            renderThumbnail = true;
        }
        String thumbId = component.getMFor() + "-thumb";
        if (renderThumbnail) {
            writer.startElement("span", (UIComponent)component);
            String styleClass = component.getBaseClass();
            writer.writeAttribute("id", (Object)clientId, null);
            if (component.getStyleClass() != null) {
                styleClass = styleClass + " " + component.getStyleClass();
            }
            writer.writeAttribute("class", (Object)styleClass, null);
            String style = component.getStyle();
            if (style != null) {
                writer.writeAttribute("style", (Object)style, null);
            }
            writer.startElement("img", (UIComponent)component);
            writer.writeAttribute("width", (Object)"64", null);
            writer.writeAttribute("height", (Object)"64", null);
            writer.writeAttribute("id", (Object)thumbId, null);
            writer.endElement("img");
            writer.endElement("span");
        }
        writer.startElement("script", (UIComponent)component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        StringBuilder script = new StringBuilder("if (!window['thumbnails" + mFor + "']) {\n");
        script.append(" window['thumbnails" + mFor + "'] = {};\n}");
        script.append("\t\t window['thumbnails" + mFor + "']['" + thumbId + "'] = '" + clientId + "_data';");
        writer.write(script.toString());
        writer.endElement("script");
    }
}

