/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.timespinner;

import java.io.IOException;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.icefaces.ace.util.ComponentUtils;
import org.icefaces.ace.util.Utils;
import org.icefaces.mobi.component.timespinner.TimeSpinner;
import org.icefaces.mobi.renderkit.InputRenderer;

public class TimeSpinnerRenderer
extends InputRenderer {
    public static final String TOUCH_START_EVENT = "ontouchstart";
    public static final String CLICK_EVENT = "onclick";
    private static final Logger logger = Logger.getLogger(TimeSpinnerRenderer.class.getName());

    static boolean shouldUseNative(TimeSpinner component) {
        return component.isUseNative() && Utils.getClientDescriptor().isHasNativeDatePicker();
    }

    public void decode(FacesContext context, UIComponent component) {
        TimeSpinner timeSpinner = (TimeSpinner)component;
        String clientId = timeSpinner.getClientId(context);
        if (timeSpinner.isDisabled()) {
            return;
        }
        String inputField = clientId + "_input";
        String inputValue = (String)context.getExternalContext().getRequestParameterMap().get(inputField);
        if (TimeSpinnerRenderer.shouldUseNative(timeSpinner)) {
            inputValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId);
            String twenty4HrString = this.convertToClock(inputValue, 24);
            timeSpinner.setSubmittedValue(twenty4HrString);
        } else {
            timeSpinner.setSubmittedValue(inputValue);
        }
        this.decodeBehaviors(context, (UIComponent)timeSpinner);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        TimeSpinner spinner = (TimeSpinner)component;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = spinner.getClientId(context);
        ClientBehaviorHolder cbh = (ClientBehaviorHolder)component;
        boolean hasBehaviors = !cbh.getClientBehaviors().isEmpty();
        String initialValue = ComponentUtils.getStringValueToRender((FacesContext)context, (UIComponent)component);
        spinner.setTouchEnabled(Utils.isTouchEventEnabled((FacesContext)context));
        if (TimeSpinnerRenderer.shouldUseNative(spinner)) {
            writer.startElement("span", component);
            writer.writeAttribute("id", (Object)(clientId + "_wrap"), null);
            writer.startElement("input", component);
            writer.writeAttribute("type", (Object)"time", "type");
            writer.writeAttribute("id", (Object)clientId, null);
            this.renderResetSettings(context, component, "timespinner");
            writer.writeAttribute("name", (Object)clientId, null);
            String styleClass = spinner.getStyleClass();
            String style = spinner.getStyle();
            if (style != null) {
                writer.writeAttribute("style", (Object)style, "style");
            }
            if (styleClass != null) {
                writer.writeAttribute("class", (Object)styleClass, "class");
            }
            boolean disabled = spinner.isDisabled();
            boolean readonly = spinner.isReadonly();
            String defaultPattern = "HH:mm";
            SimpleDateFormat df2 = new SimpleDateFormat(defaultPattern);
            if (this.isValueBlank(initialValue)) {
                Date aDate = new Date();
                writer.writeAttribute("value", (Object)df2.format(aDate), "value");
            } else {
                if (!this.isFormattedDate(initialValue, "HH:mm")) {
                    initialValue = this.convertStringInput("EEE MMM dd hh:mm:ss zzz yyyy", defaultPattern, initialValue);
                }
                writer.writeAttribute("value", (Object)initialValue, "value");
            }
            if (disabled) {
                writer.writeAttribute("disabled", (Object)component, "disabled");
            }
            if (readonly) {
                writer.writeAttribute("readonly", (Object)component, "readonly");
            }
            if (!readonly && !disabled && hasBehaviors) {
                String event = "onchange";
                String cbhCall = this.buildAjaxRequest(context, cbh, event);
                cbhCall = cbhCall.replace("\"", "'");
                writer.writeAttribute(event, (Object)("ice.setFocus(''); ice.ace.ab(" + cbhCall + ");"), null);
            }
            ComponentUtils.renderPassThroughAttributes((ResponseWriter)writer, (UIComponent)spinner, (String[])spinner.getCommonAttributeNames());
            writer.endElement("input");
            writer.startElement("span", component);
            writer.writeAttribute("id", (Object)(clientId + "_useNativeInit"), null);
            writer.writeAttribute("class", (Object)"mobi-hidden", null);
            writer.writeAttribute("id", (Object)(clientId + "_script"), "id");
            writer.startElement("script", null);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            String nativeInitScr = "mobi.timespinner.nativeInit('" + clientId + "','" + initialValue + "' );";
            writer.write(nativeInitScr);
            writer.endElement("script");
            writer.endElement("span");
            writer.endElement("span");
        } else {
            String value = this.encodeValue(spinner, initialValue);
            this.encodeMarkup(context, component, value, hasBehaviors);
            this.encodeScript(context, component, value);
        }
    }

    protected void encodeMarkup(FacesContext context, UIComponent uiComponent, String value, boolean hasBehaviors) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        TimeSpinner timeEntry = (TimeSpinner)uiComponent;
        String clientId = timeEntry.getClientId(context);
        ClientBehaviorHolder cbh = (ClientBehaviorHolder)uiComponent;
        String eventStr = timeEntry.isTouchEnabled() ? TOUCH_START_EVENT : CLICK_EVENT;
        boolean readonly = timeEntry.isReadonly();
        boolean disabled = timeEntry.isDisabled();
        boolean disabledOrReadonly = false;
        if (readonly || disabled) {
            disabledOrReadonly = true;
        }
        writer.startElement("span", uiComponent);
        String styleClass = timeEntry.getStyleClass();
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "class");
        }
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, "name");
        writer.writeAttribute("class", (Object)"mobi-time-wrapper", "class");
        writer.startElement("input", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_input"), "id");
        writer.writeAttribute("name", (Object)(clientId + "_input"), "name");
        this.renderResetSettings(context, uiComponent, "timespinner");
        if (!disabledOrReadonly) {
            StringBuilder onblur = new StringBuilder(255);
            onblur.append("mobi.timespinner.inputSubmit('").append(clientId).append("',{ event: event");
            if (hasBehaviors) {
                String behaviors = this.encodeClientBehaviors(context, cbh, "change").toString();
                behaviors = behaviors.replace("\"", "'");
                onblur.append(behaviors);
            }
            onblur.append("});");
            writer.writeAttribute("onblur", (Object)onblur.toString(), null);
        }
        ComponentUtils.renderPassThroughAttributes((ResponseWriter)writer, (UIComponent)timeEntry, (String[])timeEntry.getCommonAttributeNames());
        String style = timeEntry.getStyle();
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        StringBuilder classNames = new StringBuilder("mobi-input-text");
        writer.writeAttribute("class", (Object)classNames.toString(), null);
        if (value != null) {
            writer.writeAttribute("value", (Object)value, null);
        }
        writer.writeAttribute("type", (Object)"text", "type");
        if (readonly) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.endElement("input");
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"button", "type");
        writer.writeAttribute("value", (Object)"", null);
        writer.writeAttribute("class", (Object)"mobi-time-popup-btn", null);
        if (timeEntry.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (!disabledOrReadonly) {
            writer.writeAttribute(CLICK_EVENT, (Object)("mobi.timespinner.toggle('" + clientId + "');"), null);
        }
        writer.endElement("input");
        writer.endElement("span");
        writer.endElement("span");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_bg"), "id");
        writer.writeAttribute("class", (Object)"mobi-time-bg-inv", "class");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_popup"), "id");
        writer.writeAttribute("class", (Object)"mobi-time-container-inv ui-widget ui-widget-content", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_title"), "id");
        writer.writeAttribute("class", (Object)"mobi-time-title-container ui-widget-header", null);
        writer.startElement("span", uiComponent);
        writer.writeAttribute("class", (Object)"fa fa-clock-o", null);
        writer.endElement("span");
        writer.startElement("span", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-title", null);
        writer.endElement("span");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-select-container ui-widget-content", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-select-value-cont", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn-cont-incr", null);
        writer.startElement("button", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn mobi-time-btn-incr ui-button ui-state-default", null);
        writer.writeAttribute("id", (Object)(clientId + "_hrUpBtn"), null);
        writer.writeAttribute(eventStr, (Object)("mobi.timespinner.hrUp('" + clientId + "');return false;"), null);
        this.writePlusIcon(writer);
        writer.endElement("button");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-select-value", null);
        writer.writeAttribute("id", (Object)(clientId + "_hrInt"), null);
        writer.write(String.valueOf(timeEntry.getHourInt()));
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn-cont-decr", null);
        writer.startElement("button", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn mobi-time-btn-decr ui-button ui-state-default", null);
        writer.writeAttribute("id", (Object)(clientId + "_hrDnBtn"), null);
        writer.writeAttribute(eventStr, (Object)("mobi.timespinner.hrDn('" + clientId + "');return false;"), null);
        this.writeMinusIcon(writer);
        writer.endElement("button");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-select-value-cont", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn-cont-incr", null);
        writer.startElement("button", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn mobi-time-btn-incr ui-button ui-state-default", null);
        writer.writeAttribute("id", (Object)(clientId + "_mUpBtn"), null);
        writer.writeAttribute(eventStr, (Object)("mobi.timespinner.mUp('" + clientId + "');return false;"), null);
        this.writePlusIcon(writer);
        writer.endElement("button");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-select-value", null);
        writer.writeAttribute("id", (Object)(clientId + "_mInt"), null);
        writer.write(String.valueOf(timeEntry.getMinuteInt()));
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn-cont-decr", null);
        writer.startElement("button", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn mobi-time-btn-decr ui-button ui-state-default", null);
        writer.writeAttribute("id", (Object)(clientId + "_mDnBtn"), null);
        writer.writeAttribute(eventStr, (Object)("mobi.timespinner.mDn('" + clientId + "');return false;"), null);
        this.writeMinusIcon(writer);
        writer.endElement("button");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-select-value-cont", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn-cont-incr", null);
        writer.startElement("button", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn mobi-time-btn-incr ui-button ui-state-default", null);
        writer.writeAttribute("id", (Object)(clientId + "_ampmUpBtn"), null);
        writer.writeAttribute(eventStr, (Object)("mobi.timespinner.ampmToggle('" + clientId + "');return false;"), null);
        this.writePlusIcon(writer);
        writer.endElement("button");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-select-value", null);
        writer.writeAttribute("id", (Object)(clientId + "_ampmInt"), null);
        String ampm = "AM";
        if (timeEntry.getAmpm() > 0) {
            ampm = "PM";
        }
        writer.write(ampm);
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn-cont-decr", null);
        writer.startElement("button", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-btn mobi-time-btn-decr ui-button ui-state-default", null);
        writer.writeAttribute("id", (Object)(clientId + "_ampmBtn"), null);
        writer.writeAttribute(eventStr, (Object)("mobi.timespinner.ampmToggle('" + clientId + "');return false;"), null);
        this.writeMinusIcon(writer);
        writer.endElement("button");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-time-submit-container ui-widget-content", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-button ui-btn-up-c", null);
        writer.writeAttribute("type", (Object)"button", "type");
        writer.writeAttribute("value", (Object)"Set", null);
        StringBuilder builder = new StringBuilder(255);
        builder.append("mobi.timespinner.select('").append(clientId).append("',{ event: event");
        if (hasBehaviors) {
            String behaviors = this.encodeClientBehaviors(context, cbh, "change").toString();
            behaviors = behaviors.replace("\"", "'");
            builder.append(behaviors);
        }
        builder.append("});");
        String jsCall = builder.toString();
        if (!timeEntry.isDisabled() || !timeEntry.isReadonly()) {
            writer.writeAttribute(CLICK_EVENT, (Object)(jsCall + "return false;"), null);
        }
        writer.endElement("input");
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-button ui-btn-up-c", null);
        writer.writeAttribute("type", (Object)"button", "type");
        writer.writeAttribute("value", (Object)"Cancel", null);
        writer.writeAttribute(CLICK_EVENT, (Object)("mobi.timespinner.close('" + clientId + "');"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.endElement("div");
    }

    public void encodeScript(FacesContext context, UIComponent uiComponent, String value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        TimeSpinner spinner = (TimeSpinner)uiComponent;
        String clientId = spinner.getClientId(context);
        int hourInt = spinner.getHourInt();
        int minuteInt = spinner.getMinuteInt();
        int ampm = spinner.getAmpm();
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_script"), "id");
        writer.writeAttribute("class", (Object)"mobi-hidden", null);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("mobi.timespinner.init('" + clientId + "'," + hourInt + "," + minuteInt + "," + ampm + ",'" + spinner.getPattern() + "','" + value + "');");
        writer.endElement("script");
        writer.endElement("span");
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object value) throws ConverterException {
        TimeSpinner spinner = (TimeSpinner)component;
        String submittedValue = String.valueOf(value);
        Converter converter = spinner.getConverter();
        if (this.isValueBlank(submittedValue)) {
            return null;
        }
        if (converter != null) {
            Object objVal = converter.getAsObject(context, (UIComponent)spinner, submittedValue);
            return objVal;
        }
        try {
            Locale locale = spinner.calculateLocale(context);
            if (!TimeSpinnerRenderer.shouldUseNative(spinner)) {
                SimpleDateFormat format = new SimpleDateFormat(spinner.getPattern(), locale);
                return this.customConversion(context, spinner, format, submittedValue);
            }
            SimpleDateFormat format = new SimpleDateFormat("HH:mm", locale);
            return this.customConversion(context, spinner, format, submittedValue);
        }
        catch (ParseException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    private Object customConversion(FacesContext context, TimeSpinner spinner, SimpleDateFormat format, String submittedValue) throws ParseException {
        Locale locale = spinner.calculateLocale(context);
        format.setTimeZone(spinner.calculateTimeZone());
        Date nativeValue = format.parse(submittedValue);
        return nativeValue;
    }

    private void setIntValues(TimeSpinner spinner, Date aDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(aDate);
        int hourInt = cal.get(10);
        if (0 == hourInt) {
            hourInt = 12;
        }
        spinner.setHourInt(hourInt);
        spinner.setMinuteInt(cal.get(12));
        spinner.setAmpm(cal.get(9));
    }

    private String convertStringInput(String patternIn, String patternOut, String inString) {
        SimpleDateFormat df1 = new SimpleDateFormat(patternIn);
        SimpleDateFormat df2 = new SimpleDateFormat(patternOut);
        String returnString = inString;
        try {
            Date aDate = df1.parse(inString);
            returnString = df2.format(aDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnString;
    }

    private String encodeValue(TimeSpinner spinner, String initialValue) {
        String value = "";
        Date aDate = new Date();
        SimpleDateFormat df2 = new SimpleDateFormat(spinner.getPattern());
        if (!this.isValueBlank(initialValue)) {
            try {
                if (this.isFormattedDate(initialValue, spinner.getPattern())) {
                    value = initialValue;
                    aDate = df2.parse(value);
                } else if (this.isFormattedDate(initialValue, "EEE MMM dd hh:mm:ss zzz yyyy")) {
                    value = this.convertStringInput("EEE MMM dd hh:mm:ss zzz yyyy", spinner.getPattern(), initialValue);
                    aDate = df2.parse(value);
                }
            }
            catch (Exception e) {
                throw new ConverterException();
            }
        }
        this.setIntValues(spinner, aDate);
        return value;
    }

    private boolean isFormattedDate(String inStr, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.parse(inStr, new ParsePosition(0)) != null;
    }

    private String convertToClock(String inputVal, int hours) {
        if (!this.isValueEmpty(inputVal)) {
            String delim = ":";
            String[] tmp = inputVal.split(delim);
            String hr = tmp[0];
            String min = tmp[1];
            if (min.length() == 1) {
                min = min + "0";
            }
            String retVal = null;
            try {
                int hour = Integer.parseInt(hr);
                int minute = Integer.parseInt(min);
                retVal = hours == 12 ? (hour < 13 && minute <= 59 ? hr + ":" + min + " AM" : String.valueOf(hour - 12) + ":" + min + " PM") : hr + ":" + min;
            }
            catch (NumberFormatException nfe) {
                logger.info("not able to convert iOS5 input to " + hours + "hour clock");
            }
            return retVal;
        }
        return inputVal;
    }

    private void writePlusIcon(ResponseWriter writer) throws IOException {
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"fa fa-plus", null);
        writer.endElement("span");
    }

    private void writeMinusIcon(ResponseWriter writer) throws IOException {
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"fa fa-minus", null);
        writer.endElement("span");
    }
}

