/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.viewmanager;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlBody;
import javax.faces.component.html.HtmlForm;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.icefaces.ace.util.Utils;
import org.icefaces.impl.event.BridgeSetup;
import org.icefaces.mobi.component.viewmanager.View;
import org.icefaces.mobi.component.viewmanager.ViewManager;

public class ViewManagerRenderer
extends Renderer {
    private static final Logger LOG = Logger.getLogger(ViewManagerRenderer.class.getName());

    public void decode(FacesContext context, UIComponent component) {
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ViewManager vm = (ViewManager)uiComponent;
        this.validate(vm, facesContext);
        Stack<String> history = vm.getHistoryStack();
        if (history == null) {
            vm.setHistory(new Stack());
            history = vm.getHistoryStack();
        }
        String selected = vm.getSelected();
        String formId = vm.getId() + "_form";
        for (int i = 0; i < vm.getChildCount(); ++i) {
            UIComponent comp = (UIComponent)vm.getChildren().get(i);
            if (!comp.getId().equals(formId)) continue;
            vm.getChildren().remove(i);
            break;
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = vm.getClientId();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("data-title", (Object)vm.getTitle(), null);
        writer.writeAttribute("data-clientside", (Object)vm.isClientSide(), null);
        String styleClass = "mobi-vm";
        String userClass = vm.getStyleClass();
        if (userClass != null) {
            styleClass = styleClass + " " + userClass;
        }
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        String userStyle = vm.getStyle();
        if (userStyle != null) {
            writer.writeAttribute("style", (Object)userStyle, "style");
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(vm.getClientId() + "_header"), null);
        writer.writeAttribute("class", (Object)"mobi-vm-header mobi-vm-bar", null);
        String headerStyle = vm.getHeaderStyle();
        if (headerStyle != null) {
            writer.writeAttribute("style", (Object)headerStyle, null);
        }
        writer.startElement("h1", null);
        writer.writeAttribute("id", (Object)(clientId + "_title"), "pageTitle");
        writer.endElement("h1");
        writer.startElement("a", null);
        writer.writeAttribute("id", (Object)(clientId + "_back"), null);
        writer.writeAttribute("class", (Object)"mobi-vm-back", null);
        writer.writeAttribute("onclick", (Object)"ice.mobi.viewManager.goBack(event);", null);
        writer.writeAttribute("data-backbutton-label", (Object)vm.getBackButtonLabel(), null);
        writer.writeAttribute("style", (Object)"display:none", null);
        writer.startElement("i", null);
        writer.writeAttribute("class", (Object)"fa fa-chevron-left", null);
        writer.endElement("i");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"mobi-vm-back-text", null);
        writer.endElement("span");
        writer.endElement("a");
        writer.endElement("div");
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_menu"), null);
        writer.writeAttribute("data-view", (Object)"mobiViewManagerMenu", null);
        writer.writeAttribute("data-title", (Object)vm.getTitle(), null);
        writer.writeAttribute("class", (Object)"mobi-vm-view mobi-vm-menu", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"mobi-vm-view-content", null);
        writer.startElement("ul", null);
        List children = vm.getChildren();
        for (UIComponent child : children) {
            View view = (View)child;
            if (!view.isIncludeInMenu()) continue;
            String divider = view.getDivider();
            if (divider != null) {
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)"mobi-vm-menu-divider mobi-vm-bar", null);
                writer.write(divider);
                writer.endElement("li");
            }
            writer.startElement("li", null);
            writer.startElement("a", null);
            writer.writeAttribute("onclick", (Object)("ice.mobi.viewManager.showView('" + view.getId() + "', event);"), null);
            if (view.getMenuIcon() != null) {
                writer.startElement("i", null);
                writer.writeAttribute("class", (Object)("mobi-vm-menu-icon fa fa-" + view.getMenuIcon()), null);
                writer.endElement("i");
            }
            writer.write(view.getTitle());
            writer.endElement("a");
            writer.endElement("li");
        }
        writer.endElement("ul");
        writer.endElement("div");
        writer.endElement("div");
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Utils.renderChildren((FacesContext)facesContext, (UIComponent)uiComponent);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        ViewManager vm = (ViewManager)uiComponent;
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)"mobiImageCache", null);
        writer.writeAttribute("class", (Object)"mobi-vm-image-cache", null);
        writer.endElement("div");
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)(uiComponent.getClientId() + "_controller"), null);
        writer.writeAttribute("class", (Object)"mobi-hidden", null);
        this.createAndRenderProxyForm(vm, facesContext, writer);
        writer.startElement("style", null);
        writer.writeAttribute("type", (Object)"text/css", null);
        writer.write(".mobi-vm-bar{" + vm.getBarStyle() + "}");
        writer.endElement("style");
        writer.startElement("script", null);
        String state = "ice.mobi.viewManager.setState('" + vm.getTransitionType() + "','" + vm.getId() + "_form'," + vm.getHistoryAsJSON() + ");";
        writer.write(state);
        writer.endElement("script");
        writer.endElement("span");
        writer.endElement("div");
    }

    private void createAndRenderProxyForm(ViewManager vm, FacesContext context, ResponseWriter writer) throws IOException {
        Application application = context.getApplication();
        HtmlForm form = (HtmlForm)application.createComponent("javax.faces.HtmlForm");
        String formId = vm.getId() + "_form";
        form.setId(formId);
        vm.getChildren().add(form);
        form.encodeBegin(context);
        String viewId = BridgeSetup.getViewID((ExternalContext)context.getExternalContext());
        if (viewId != null) {
            writer.startElement("input", null);
            writer.writeAttribute("type", (Object)"hidden", null);
            writer.writeAttribute("name", (Object)"ice.view", null);
            writer.writeAttribute("value", (Object)viewId, null);
            writer.writeAttribute("autocomplete", (Object)"off", null);
            writer.endElement("input");
        }
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)"mobi_vm_selected", null);
        writer.writeAttribute("name", (Object)(vm.getClientId() + "_selected"), null);
        writer.writeAttribute("value", (Object)vm.getSelected(), null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        writer.endElement("input");
        form.encodeEnd(context);
    }

    private void validate(ViewManager vm, FacesContext context) {
        if (!(vm.getParent() instanceof HtmlBody)) {
            throw new IllegalStateException("The viewManager component must be the direct child of the <h:body> tag");
        }
        if (this.countViewManagers((UIComponent)context.getViewRoot()) > 1) {
            throw new IllegalStateException("Only one viewManager is allowed on a page");
        }
    }

    private int countViewManagers(UIComponent uic) {
        int count = 0;
        if (uic instanceof ViewManager) {
            ++count;
        }
        Iterator iter = uic.getFacetsAndChildren();
        while (iter.hasNext()) {
            UIComponent child = (UIComponent)iter.next();
            count += this.countViewManagers(child);
        }
        return count;
    }
}

