/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.renderkit;

import java.io.IOException;
import java.util.logging.Logger;
import org.icefaces.mobi.api.IBaseComponent;
import org.icefaces.mobi.api.IMobiComponent;
import org.icefaces.mobi.renderkit.IResponseWriter;
import org.icefaces.util.ClientDescriptor;

public abstract class BaseCoreRenderer {
    private static final Logger logger = Logger.getLogger(BaseCoreRenderer.class.toString());

    public void writeStandardAttributes(IResponseWriter writer, IMobiComponent component, String baseClass, String disabledClass) throws IOException {
        StringBuilder inputStyle = new StringBuilder(baseClass);
        if (component.isDisabled()) {
            inputStyle.append(" ").append(disabledClass);
        }
        if (null != component.getStyleClass()) {
            inputStyle.append(" ").append(component.getStyleClass());
        }
        if (inputStyle.length() > 0) {
            writer.writeAttribute("class", inputStyle);
        }
        if (null != component.getStyle()) {
            writer.writeAttribute("style", component.getStyle());
        }
        if (component.isDisabled()) {
            writer.writeAttribute("disabled", "disabled");
        }
    }

    public void writeStandardLayoutAttributes(IResponseWriter writer, IBaseComponent component, String baseClass) throws IOException {
        StringBuilder inputStyle = new StringBuilder(baseClass);
        if (null != component.getStyleClass()) {
            inputStyle.append(" ").append(component.getStyleClass());
        }
        if (inputStyle.length() > 0) {
            writer.writeAttribute("class", inputStyle);
        }
        if (null != component.getStyle()) {
            writer.writeAttribute("style", component.getStyle());
        }
    }

    public void encodeHiddenSelected(IResponseWriter writer, String id, Object selectedIndex, String name) throws IOException {
        writer.startElement("input");
        writer.writeAttribute("id", id + "_hidden");
        writer.writeAttribute("name", name);
        writer.writeAttribute("type", "hidden");
        writer.writeAttribute("value", String.valueOf(selectedIndex));
        writer.endElement("input");
    }

    public void writeHiddenInput(IResponseWriter writer, IMobiComponent comp) throws IOException {
        writer.startElement("span", comp);
        writer.startElement("input", comp);
        writer.writeAttribute("type", "hidden");
        writer.writeAttribute("id", comp.getClientId() + "_hidden");
        writer.writeAttribute("name", comp.getClientId() + "_hidden");
        writer.endElement("input");
        writer.endElement("span");
    }

    public void writeHiddenInput(IResponseWriter writer, IMobiComponent comp, String value) throws IOException {
        writer.startElement("span", comp);
        writer.startElement("input", comp);
        writer.writeAttribute("type", "hidden");
        writer.writeAttribute("id", comp.getClientId() + "_hidden");
        writer.writeAttribute("name", comp.getClientId() + "_hidden");
        writer.writeAttribute("value", value);
        writer.endElement("input");
        writer.endElement("span");
    }

    public void writeExternalScript(IMobiComponent component, IResponseWriter writer, String url) throws IOException {
        this.writeExternalScript(component, writer, url, true);
    }

    public void writeExternalScript(IMobiComponent component, IResponseWriter writer, String url, boolean required) throws IOException {
        writer.startElement("span", null);
        writer.writeAttribute("id", component.getClientId() + "_libJS");
        writer.writeAttribute("class", "mobi-hidden");
        if (required) {
            writer.startElement("script", null);
            writer.writeAttribute("type", "text/javascript");
            writer.writeAttribute("src", url);
            writer.endElement("script");
        }
        writer.endElement("span");
    }

    protected boolean isTouchEventEnabled(ClientDescriptor client) {
        if (client.isAndroidOS() && client.isTabletBrowser()) {
            return false;
        }
        return client.isIOS() || client.isAndroidOS();
    }

    protected boolean isStringAttributeEmpty(String inString) {
        if (inString == null) {
            return true;
        }
        if (inString.trim().equals("")) {
            return true;
        }
        return inString.length() < 1;
    }
}

