/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.core;

import com.icesoft.faces.context.View;
import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Response;
import com.icesoft.faces.webapp.http.common.ResponseHandler;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.core.LifecycleExecutor;
import com.icesoft.faces.webapp.http.core.ReloadResponse;
import com.icesoft.faces.webapp.http.core.SendUpdates;
import com.icesoft.faces.webapp.http.core.SessionExpiredException;
import com.icesoft.faces.webapp.http.core.SessionExpiredResponse;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import com.icesoft.util.SeamUtilities;
import com.icesoft.util.pooling.CSSNamePool;
import com.icesoft.util.pooling.ClientIdPool;
import com.icesoft.util.pooling.ELPool;
import com.icesoft.util.pooling.XhtmlPool;
import java.util.Collection;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReceiveSendUpdates
implements Server {
    private static final Log log = LogFactory.getLog((Class)ReceiveSendUpdates.class);
    private static final ResponseHandler MissingParameterHandler = new ResponseHandler(){

        public void respond(Response response) throws Exception {
            response.setStatus(500);
            response.writeBody().write("Cannot match view instance. 'ice.view' parameter is missing.".getBytes());
        }
    };
    private static Lifecycle lifecycle;
    private final SessionDispatcher.Monitor sessionMonitor;
    private final Map views;
    private final Collection synchronouslyUpdatedViews;

    public ReceiveSendUpdates(Map views, Collection synchronouslyUpdatedViews, SessionDispatcher.Monitor sessionMonitor) {
        this.views = views;
        this.synchronouslyUpdatedViews = synchronouslyUpdatedViews;
        this.sessionMonitor = sessionMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Request request) throws Exception {
        String viewNumber = request.getParameter("ice.view");
        if (viewNumber == null) {
            request.respondWith(MissingParameterHandler);
        } else {
            View view = (View)this.views.get(viewNumber);
            if (view == null) {
                request.respondWith(new ReloadResponse(viewNumber));
            } else {
                try {
                    view.processPostback(request);
                    this.sessionMonitor.touchSession();
                    this.synchronouslyUpdatedViews.add(viewNumber);
                    this.renderCycle(view.getFacesContext());
                    this.synchronouslyUpdatedViews.remove(viewNumber);
                    request.respondWith(new SendUpdates.Handler(this.views, request));
                    log.debug((Object)("String intern pools sizes:\nClientIdPool: " + ClientIdPool.getSize() + "\nCSSNamePool: " + CSSNamePool.getSize() + "\nELPool: " + ELPool.getSize() + "\nXhtmlPool: " + XhtmlPool.getSize()));
                }
                catch (FacesException e) {
                    Throwable nestedException = e.getCause();
                    if (nestedException == null) {
                        throw e;
                    }
                    throw ReceiveSendUpdates.findInitialCause(nestedException, e);
                }
                catch (SessionExpiredException e) {
                    request.respondWith(SessionExpiredResponse.Handler);
                }
                finally {
                    view.release();
                }
            }
        }
    }

    public void shutdown() {
    }

    private static Exception findInitialCause(Throwable nestedException, FacesException defaultException) {
        while (nestedException.getCause() != null) {
            nestedException = nestedException.getCause();
        }
        if (nestedException instanceof Exception) {
            return (Exception)nestedException;
        }
        return defaultException;
    }

    private void renderCycle(FacesContext context) {
        SeamUtilities.removeSeamDebugPhaseListener(lifecycle);
        LifecycleExecutor.getLifecycleExecutor(context).apply(context);
    }

    static {
        LifecycleFactory LifecycleFactory2 = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        lifecycle = LifecycleFactory2.getLifecycle("DEFAULT");
    }
}

