/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.portlet;

import com.icesoft.faces.context.BridgeExternalContext;
import com.icesoft.faces.context.View;
import com.icesoft.faces.env.Authorization;
import com.icesoft.faces.env.RequestAttributes;
import com.icesoft.faces.util.EnumerationIterator;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.portlet.AllowMode;
import com.icesoft.faces.webapp.http.portlet.InterceptingPortletSession;
import com.icesoft.faces.webapp.http.portlet.PortletContextAttributeMap;
import com.icesoft.faces.webapp.http.portlet.PortletContextInitParameterMap;
import com.icesoft.faces.webapp.http.portlet.PortletEnvironmentRenderRequest;
import com.icesoft.faces.webapp.http.portlet.PortletRequestAllowMode;
import com.icesoft.faces.webapp.http.portlet.PortletRequestAttributeMap;
import com.icesoft.faces.webapp.http.portlet.PortletRequestAttributes;
import com.icesoft.faces.webapp.http.portlet.PortletSessionAttributeMap;
import com.icesoft.faces.webapp.http.servlet.ServletRequestAttributes;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import com.icesoft.util.SeamUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PortletExternalContext
extends BridgeExternalContext {
    private static final Log Log = LogFactory.getLog((Class)BridgeExternalContext.class);
    private static final AllowMode DoNotAllow = new AllowMode(){

        public boolean isPortletModeAllowed(PortletMode portletMode) {
            return false;
        }

        public boolean isWindowStateAllowed(WindowState windowState) {
            return false;
        }
    };
    private static final BridgeExternalContext.Redirector NOOPRedirector = new BridgeExternalContext.Redirector(){

        public void redirect(String uri) {
        }
    };
    private static final BridgeExternalContext.CookieTransporter NOOPCookieTransporter = new BridgeExternalContext.CookieTransporter(){

        public void send(Cookie cookie) {
        }
    };
    private final PortletContext context;
    private final PortletConfig config;
    private final PortletSession session;
    private PortletEnvironmentRenderRequest initialRequest;
    private RenderResponse response;
    private AllowMode allowMode;
    private BridgeExternalContext.Dispatcher dispatcher;
    private RequestAttributes requestAttributes;
    private Configuration configuration;
    private List locales;
    public static final String INACTIVE_INCREMENT = "inactiveIncrement";
    private boolean adjustPortletSessionInactiveInterval = true;
    String contextPath = null;

    public PortletExternalContext(String viewIdentifier, Object request, Object response, View commandQueue, Configuration configuration, SessionDispatcher.Monitor monitor, Object portletConfig, Authorization authorization) {
        super(viewIdentifier, commandQueue, configuration, authorization);
        RenderRequest renderRequest = (RenderRequest)request;
        RenderResponse renderResponse = (RenderResponse)response;
        this.configuration = configuration;
        this.config = (PortletConfig)portletConfig;
        this.session = new InterceptingPortletSession(renderRequest.getPortletSession(), monitor);
        this.context = this.session.getPortletContext();
        this.initParameterMap = new PortletContextInitParameterMap(this.context);
        this.applicationMap = new PortletContextAttributeMap(this.context);
        this.sessionMap = new PortletSessionAttributeMap(this.session);
        this.requestMap = Collections.EMPTY_MAP;
        this.adjustPortletSessionInactiveInterval = configuration.getAttributeAsBoolean("portlet.adjustSessionInactiveInterval", configuration.getAttributeAsBoolean("adjustPortletSessionInactiveInterval", true));
        this.updateOnPageLoad(renderRequest, renderResponse);
        this.insertNewViewrootToken();
        this.switchToNormalMode();
    }

    public Object getSession(boolean create) {
        return this.session;
    }

    public Object getContext() {
        return this.context;
    }

    public Object getRequest() {
        return this.initialRequest;
    }

    public Object getResponse() {
        return this.response;
    }

    public void update(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies;
        if (this.adjustPortletSessionInactiveInterval) {
            this.adjustPortletSessionInactiveInterval();
        }
        boolean persistSeamKey = this.isSeamLifecycleShortcut();
        this.recreateParameterAndCookieMaps();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            this.requestParameterMap.put(name, request.getParameter(name));
            this.requestParameterValuesMap.put(name, request.getParameterValues(name));
        }
        Object req = request.getAttribute("javax.portlet.request");
        if (req != null && req instanceof PortletRequest) {
            PortletRequest portletRequest = (PortletRequest)req;
            Enumeration propertyNames = portletRequest.getPropertyNames();
            while (propertyNames.hasMoreElements()) {
                String name = (String)propertyNames.nextElement();
                this.requestHeaderMap.put(name, portletRequest.getProperty(name));
                this.requestHeaderValuesMap.put(name, portletRequest.getProperties(name));
            }
        }
        if (persistSeamKey) {
            this.setSeamLifecycleShortcut();
        }
        if ((cookies = request.getCookies()) != null) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                this.requestCookieMap.put(cookie.getName(), cookie);
            }
        }
        this.allowMode = DoNotAllow;
        this.requestAttributes = new ServletRequestAttributes(request);
        this.dispatcher = CannotDispatchOnXMLHTTPRequest;
    }

    private void adjustPortletSessionInactiveInterval() {
        long inactiveIncrement;
        Object inactiveIncObj = this.session.getAttribute(INACTIVE_INCREMENT);
        if (inactiveIncObj == null) {
            inactiveIncrement = this.session.getMaxInactiveInterval() * 1000;
            this.session.setAttribute(INACTIVE_INCREMENT, (Object)new Long(inactiveIncrement));
        } else {
            inactiveIncrement = (Long)inactiveIncObj;
        }
        long lastAccessed = this.session.getLastAccessedTime();
        this.session.setMaxInactiveInterval((int)((System.currentTimeMillis() - lastAccessed + inactiveIncrement) / 1000L));
        if (Log.isTraceEnabled()) {
            Log.trace((Object)("max inactive interval adjust to " + this.session.getMaxInactiveInterval()));
        }
    }

    public void update(RenderRequest request, RenderResponse response) {
        boolean persistSeamKey = this.isSeamLifecycleShortcut();
        this.recreateParameterAndCookieMaps();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            this.requestParameterMap.put(name, request.getParameter(name));
            this.requestParameterValuesMap.put(name, request.getParameterValues(name));
        }
        if (persistSeamKey) {
            this.setSeamLifecycleShortcut();
        }
        this.locales = Collections.list(request.getLocales());
        this.allowMode = new PortletRequestAllowMode((PortletRequest)request);
        this.requestAttributes = new PortletRequestAttributes(request);
        this.response = response;
    }

    public void updateOnPageLoad(Object request, Object response) {
        final RenderRequest renderRequest = (RenderRequest)request;
        final RenderResponse renderResponse = (RenderResponse)response;
        this.detectedAuthorization = this.detectAuthorization(renderRequest.getUserPrincipal());
        this.initialRequest = new PortletEnvironmentRenderRequest(this.session, renderRequest, this.configuration, this.detectedAuthorization){

            public AllowMode allowMode() {
                return PortletExternalContext.this.allowMode;
            }

            public RequestAttributes requestAttributes() {
                return PortletExternalContext.this.requestAttributes;
            }

            public Enumeration getLocales() {
                return Collections.enumeration(PortletExternalContext.this.locales);
            }
        };
        Map previousRequestMap = this.requestMap;
        this.requestMap = Collections.synchronizedMap(new PortletRequestAttributeMap((PortletRequest)this.initialRequest));
        this.requestMap.putAll(previousRequestMap);
        this.update(renderRequest, renderResponse);
        this.dispatcher = new BridgeExternalContext.Dispatcher(){

            public void dispatch(String path) throws IOException, FacesException {
                try {
                    PortletExternalContext.this.context.getRequestDispatcher(path).include(renderRequest, renderResponse);
                }
                catch (PortletException e) {
                    throw new FacesException((Throwable)e);
                }
            }
        };
    }

    public Map getRequestHeaderMap() {
        return this.requestHeaderMap;
    }

    public Map getRequestHeaderValuesMap() {
        return this.requestHeaderValuesMap;
    }

    public Locale getRequestLocale() {
        return this.initialRequest.getLocale();
    }

    public Iterator getRequestLocales() {
        return new EnumerationIterator(this.initialRequest.getLocales());
    }

    public String getRequestPathInfo() {
        return (String)this.initialRequest.getAttribute("javax.servlet.include.path_info");
    }

    public String getRequestURI() {
        return (String)this.initialRequest.getAttribute("javax.servlet.include.request_uri");
    }

    public String getRequestContextPath() {
        if (null == this.contextPath) {
            this.contextPath = (String)this.initialRequest.getAttribute("javax.servlet.include.context_path");
        }
        return this.contextPath;
    }

    public String getRequestServletPath() {
        return (String)this.initialRequest.getAttribute("javax.servlet.include.servlet_path");
    }

    public Set getResourcePaths(String path) {
        return this.context.getResourcePaths(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.context.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.context.getResourceAsStream(path);
    }

    public String encodeActionURL(String url) {
        return this.encodeResourceURL(url);
    }

    public String encodeResourceURL(String url) {
        try {
            return this.response.encodeURL(url);
        }
        catch (Exception e) {
            return url;
        }
    }

    public String encodeNamespace(String name) {
        return this.response.getNamespace() + name;
    }

    public void dispatch(String path) throws IOException, FacesException {
        this.dispatcher.dispatch(path);
    }

    public void log(String message) {
        this.context.log(message);
    }

    public void log(String message, Throwable throwable) {
        this.context.log(message, throwable);
    }

    public String getAuthType() {
        return this.initialRequest.getAuthType();
    }

    public String getRemoteUser() {
        return this.initialRequest.getRemoteUser();
    }

    public Principal getUserPrincipal() {
        return this.initialRequest.getUserPrincipal();
    }

    public Writer getWriter(String encoding) throws IOException {
        return this.response.getWriter();
    }

    public PortletConfig getConfig() {
        return this.config;
    }

    public void switchToNormalMode() {
        this.redirector = NOOPRedirector;
        this.cookieTransporter = NOOPCookieTransporter;
    }

    public void switchToPushMode() {
        this.redirector = new BridgeExternalContext.CommandQueueRedirector();
        this.cookieTransporter = new BridgeExternalContext.CommandQueueCookieTransporter();
        this.resetRequestMap();
    }

    public void release() {
        String requestServletPath = (String)this.requestAttributes.getAttribute("org.jboss.seam.web.requestServletPath");
        String requestContextPath = (String)this.requestAttributes.getAttribute("org.jboss.seam.web.requestContextPath");
        super.release();
        this.initialRequest.repopulatePseudoAPIAttributes();
        this.allowMode = DoNotAllow;
        this.dispatcher = RequestNotAvailable;
        if (SeamUtilities.isSeamEnvironment()) {
            this.requestAttributes.setAttribute("org.jboss.seam.web.requestServletPath", requestServletPath);
            this.requestAttributes.setAttribute("org.jboss.seam.web.requestContextPath", requestContextPath);
            this.requestAttributes.setAttribute("org.jboss.seam.web.requestPathInfo", "");
        } else {
            this.requestAttributes = NOOPRequestAttributes;
        }
    }

    public void removeSeamAttributes() {
        this.requestAttributes = NOOPRequestAttributes;
    }
}

