/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.application.ProductInfo;
import com.icesoft.faces.async.render.RenderManager;
import com.icesoft.faces.env.Authorization;
import com.icesoft.faces.util.event.servlet.ContextEventRepeater;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.common.FileLocator;
import com.icesoft.faces.webapp.http.common.MimeTypeMatcher;
import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.common.standard.NotFoundHandler;
import com.icesoft.faces.webapp.http.core.DisposeBeans;
import com.icesoft.faces.webapp.http.core.ResourceServer;
import com.icesoft.faces.webapp.http.servlet.BasicAdaptingServlet;
import com.icesoft.faces.webapp.http.servlet.DisposeViewsHandler;
import com.icesoft.faces.webapp.http.servlet.EnvironmentAdaptingServlet;
import com.icesoft.faces.webapp.http.servlet.MainSessionBoundServlet;
import com.icesoft.faces.webapp.http.servlet.PathDispatcher;
import com.icesoft.faces.webapp.http.servlet.PseudoServlet;
import com.icesoft.faces.webapp.http.servlet.ServletContextConfiguration;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import com.icesoft.faces.webapp.http.servlet.SessionVerifier;
import com.icesoft.net.messaging.AbstractMessageHandler;
import com.icesoft.net.messaging.Message;
import com.icesoft.net.messaging.MessageSelector;
import com.icesoft.net.messaging.MessageServiceAdapter;
import com.icesoft.net.messaging.MessageServiceClient;
import com.icesoft.net.messaging.MessageServiceException;
import com.icesoft.net.messaging.TextMessage;
import com.icesoft.net.messaging.expression.Equal;
import com.icesoft.net.messaging.expression.Identifier;
import com.icesoft.net.messaging.expression.StringLiteral;
import com.icesoft.net.messaging.http.HttpAdapter;
import com.icesoft.net.messaging.jms.JMSAdapter;
import com.icesoft.util.IdGenerator;
import com.icesoft.util.MonitorRunner;
import com.icesoft.util.SeamUtilities;
import com.icesoft.util.ServerUtility;
import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import java.net.URI;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MainServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog((Class)MainServlet.class);
    private static final CurrentContextPath currentContextPath = new CurrentContextPath();
    private PathDispatcher dispatcher = new PathDispatcher();
    private ServletContext context;
    private MonitorRunner monitorRunner;
    private MessageServiceClient messageServiceClient;
    private String localAddress;
    private int localPort;
    private String blockingRequestHandlerContext;
    private boolean detectionDone = false;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.context = servletConfig.getServletContext();
        try {
            final ServletContextConfiguration configuration = new ServletContextConfiguration("com.icesoft.faces", this.context);
            final IdGenerator idGenerator = new IdGenerator(this.context.getResource("/WEB-INF/web.xml").getPath());
            final MimeTypeMatcher mimeTypeMatcher = new MimeTypeMatcher(){

                public String mimeTypeFor(String extension) {
                    return MainServlet.this.context.getMimeType(extension);
                }
            };
            FileLocator localFileLocator = new FileLocator(){

                public File locate(String path) {
                    URI contextURI = URI.create(currentContextPath.lookup());
                    URI pathURI = URI.create(path);
                    String result = contextURI.relativize(pathURI).getPath();
                    String fileLocation = MainServlet.this.context.getRealPath(result);
                    return new File(fileLocation);
                }
            };
            this.monitorRunner = new MonitorRunner(configuration.getAttributeAsLong("monitorRunnerInterval", 10000L));
            RenderManager.setServletConfig(servletConfig);
            BasicAdaptingServlet resourceServer = new BasicAdaptingServlet(new ResourceServer(configuration, mimeTypeMatcher, localFileLocator));
            SessionDispatcher sessionDispatcher = new SessionDispatcher(configuration, this.context){

                protected Server newServer(HttpSession session, SessionDispatcher.Monitor sessionMonitor, Authorization authorization) {
                    return new MainSessionBoundServlet(session, sessionMonitor, idGenerator, mimeTypeMatcher, MainServlet.this.monitorRunner, configuration, MainServlet.this.getMessageServiceClient(configuration), MainServlet.this.blockingRequestHandlerContext, authorization);
                }
            };
            if (SeamUtilities.isSpringEnvironment()) {
                this.dispatcher.dispatchOn("/spring/resources/", resourceServer);
            }
            this.dispatcher.dispatchOn(".*(block\\/resource\\/)", new SessionVerifier(sessionDispatcher, false));
            if (!configuration.getAttributeAsBoolean("synchronousUpdate", false)) {
                this.dispatcher.dispatchOn(".*(block\\/message)", new PseudoServlet(){
                    private PseudoServlet notFound;
                    {
                        this.notFound = new EnvironmentAdaptingServlet(new Server(){

                            public void service(Request request) throws Exception {
                                request.respondWith(new NotFoundHandler(""));
                            }

                            public void shutdown() {
                            }
                        }, configuration, MainServlet.this.context);
                    }

                    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
                        if (MainServlet.this.messageServiceClient != null && MainServlet.this.messageServiceClient.getMessageServiceAdapter() instanceof HttpAdapter) {
                            ((HttpAdapter)MainServlet.this.messageServiceClient.getMessageServiceAdapter()).getHttpMessagingDispatcher().service(request, response);
                        } else {
                            this.notFound.service(request, response);
                        }
                    }

                    public void shutdown() {
                    }
                });
            }
            this.dispatcher.dispatchOn(".*(block\\/)", new SessionVerifier(sessionDispatcher, true));
            this.dispatcher.dispatchOn(".*(\\/$|\\.iface$|\\.jsf|\\.faces$|\\.jsp$|\\.jspx$|\\.html$|\\.xhtml$|\\.seam$|uploadHtml$|/spring/)", sessionDispatcher);
            this.dispatcher.dispatchOn(".*", resourceServer);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block14: {
            if (this.localAddress == null) {
                this.localAddress = ServerUtility.getLocalAddr(request, this.context);
                this.localPort = ServerUtility.getLocalPort(request, this.context);
            }
            try {
                currentContextPath.attach(request.getContextPath());
                this.dispatcher.service(request, response);
            }
            catch (SocketException e) {
                if ("Broken pipe".equals(e.getMessage())) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)"Connection broken by client.", (Throwable)e);
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Connection broken by client: " + e.getMessage()));
                    }
                    break block14;
                }
                throw new ServletException((Throwable)e);
            }
            catch (RuntimeException e) {
                if (e.getMessage() != null) {
                    throw e;
                }
                throw new RuntimeException("no message available", e);
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
            finally {
                currentContextPath.detach();
            }
        }
    }

    public void destroy() {
        this.monitorRunner.stop();
        DisposeBeans.in(this.context);
        this.dispatcher.shutdown();
        this.tearDownMessageServiceClient();
    }

    private synchronized MessageServiceClient getMessageServiceClient(Configuration configuration) {
        if (!this.detectionDone) {
            if (!configuration.getAttributeAsBoolean("synchronousUpdate", false)) {
                this.setUpMessageServiceClient(configuration);
            }
            this.detectionDone = true;
        }
        return this.messageServiceClient;
    }

    private boolean isJMSAvailable() {
        try {
            ((Object)((Object)this)).getClass().getClassLoader().loadClass("javax.jms.TopicConnectionFactory");
            return true;
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }

    private void setUpMessageServiceClient(Configuration configuration) {
        String blockingRequestHandler = configuration.getAttribute("blockingRequestHandler", "auto-detect");
        if (blockingRequestHandler.equalsIgnoreCase("icefaces")) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Blocking Request Handler: \"" + blockingRequestHandler + "\""));
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Adapting to Push environment.");
            }
        } else if (blockingRequestHandler.equalsIgnoreCase("push-server")) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Blocking Request Handler: \"" + blockingRequestHandler + "\""));
            }
            this.messageServiceClient = new MessageServiceClient((MessageServiceAdapter)new HttpAdapter(this.localAddress, this.localPort, this.context), currentContextPath.lookup());
            this.testMessageService(configuration);
            if (this.messageServiceClient == null) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)"Push Server not found - the Push Server must be deployed to support multiple asynchronous applications.");
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"Adapting to Push environment.");
                }
            }
        } else {
            if (blockingRequestHandler.equalsIgnoreCase("auto-detect")) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Blocking Request Handler: \"" + blockingRequestHandler + "\""));
                }
            } else if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("INVALID Blocking Request Handler: \"" + blockingRequestHandler + "\" - " + "Using \"auto-detect\""));
            }
            boolean isJMSAvailable = this.isJMSAvailable();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("JMS API Available: " + isJMSAvailable));
            }
            if (isJMSAvailable) {
                this.messageServiceClient = new MessageServiceClient((MessageServiceAdapter)new JMSAdapter(this.context), currentContextPath.lookup());
                this.testMessageService(configuration);
            }
            if (this.messageServiceClient == null) {
                this.messageServiceClient = new MessageServiceClient((MessageServiceAdapter)new HttpAdapter(this.localAddress, this.localPort, this.context), currentContextPath.lookup());
                this.testMessageService(configuration);
            }
            if (this.messageServiceClient == null) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)"Push Server not found - the Push Server must be deployed to support multiple asynchronous applications.");
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"Adapting to Push environment.");
                }
            }
        }
        if (this.messageServiceClient != null) {
            try {
                this.messageServiceClient.subscribe("icefacesPush", new DisposeViewsHandler().getMessageSelector());
                this.messageServiceClient.start();
                ContextEventRepeater.setMessageServiceClient(this.messageServiceClient);
            }
            catch (Exception exception) {
                this.messageServiceClient = null;
                this.blockingRequestHandlerContext = null;
            }
        }
    }

    private void tearDownMessageServiceClient() {
        if (this.messageServiceClient != null) {
            try {
                this.messageServiceClient.stop();
            }
            catch (MessageServiceException exception) {
                LOG.error((Object)"Failed to close connection due to some internal error!", (Throwable)exception);
            }
        }
    }

    private void testMessageService(Configuration configuration) {
        String blockingRequestHandlerContext = configuration.getAttribute("blockingRequestHandlerContext", "push-server");
        AbstractMessageHandler acknowledgeMessageHandler = new AbstractMessageHandler(new MessageSelector(new Equal(new Identifier("message_type"), new StringLiteral("Presence")))){

            public void handle(Message message) {
                if (message instanceof TextMessage) {
                    String text = ((TextMessage)message).getText();
                    int begin = 0;
                    int end = text.indexOf(";");
                    if (end != -1 && text.substring(begin, end).equals("Acknowledge")) {
                        begin = end + 1;
                        end = text.indexOf(";", begin);
                        String product = text.substring(begin, end);
                        begin = end + 1;
                        end = text.indexOf(";", begin);
                        String primary = text.substring(begin, end);
                        begin = end + 1;
                        end = text.indexOf(";", begin);
                        String secondary = text.substring(begin, end);
                        begin = end + 1;
                        end = text.indexOf(";", begin);
                        String tertiary = text.substring(begin, end);
                        begin = end + 1;
                        end = text.indexOf(";", begin);
                        String releaseType = text.substring(begin, end);
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)("Push Server detected: \"" + product + " " + primary + "." + secondary + "." + tertiary + (releaseType.equals("") ? "" : " " + releaseType) + "\""));
                        }
                        if (!(primary.equals("x") || ProductInfo.PRIMARY.equals("x") || primary.equals(ProductInfo.PRIMARY) && secondary.equals(ProductInfo.SECONDARY) || !LOG.isWarnEnabled())) {
                            LOG.warn((Object)("ICEfaces / Push Server version mismatch! - Using \"" + ProductInfo.PRODUCT + " " + ProductInfo.PRIMARY + "." + ProductInfo.SECONDARY + "." + "x\" " + "with \"" + product + " " + primary + "." + secondary + ".x\" " + "is not recommended."));
                        }
                        MainServlet.this.messageServiceClient.removeMessageHandler(this, "icefacesPush");
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)"Using Push Server Blocking Request Handler");
                        }
                    }
                }
            }
        };
        try {
            this.messageServiceClient.subscribe("icefacesPush", acknowledgeMessageHandler.getMessageSelector());
            this.messageServiceClient.addMessageHandler(acknowledgeMessageHandler, "icefacesPush");
            this.messageServiceClient.start();
            com.icesoft.util.Properties messageProperties = new com.icesoft.util.Properties();
            messageProperties.setStringProperty("destination_servletContextPath", blockingRequestHandlerContext);
            this.messageServiceClient.publishNow("Hello", (Properties)messageProperties, "Presence", "icefacesPush");
            this.blockingRequestHandlerContext = URI.create("/").resolve(blockingRequestHandlerContext + "/").toString();
        }
        catch (MessageServiceException exception) {
            this.messageServiceClient.removeMessageHandler(acknowledgeMessageHandler, "icefacesPush");
            try {
                this.messageServiceClient.unsubscribe("icefacesPush");
            }
            catch (MessageServiceException e) {
                // empty catch block
            }
            this.messageServiceClient = null;
        }
    }

    static {
        String headless = "java.awt.headless";
        if (null == System.getProperty("java.awt.headless")) {
            System.setProperty("java.awt.headless", "true");
        }
    }

    private static class CurrentContextPath
    extends ThreadLocal {
        private CurrentContextPath() {
        }

        public String lookup() {
            return (String)this.get();
        }

        public void attach(String path) {
            this.set(path);
        }

        public void detach() {
            this.set(null);
        }
    }
}

