/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.context.View;
import com.icesoft.faces.env.Authorization;
import com.icesoft.faces.util.event.servlet.ContextEventRepeater;
import com.icesoft.faces.webapp.command.CommandQueue;
import com.icesoft.faces.webapp.command.SessionExpired;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.common.MimeTypeMatcher;
import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.common.ServerProxy;
import com.icesoft.faces.webapp.http.common.standard.OKResponse;
import com.icesoft.faces.webapp.http.common.standard.PathDispatcherServer;
import com.icesoft.faces.webapp.http.common.standard.ResponseHandlerServer;
import com.icesoft.faces.webapp.http.core.DisposeBeans;
import com.icesoft.faces.webapp.http.core.DisposeViews;
import com.icesoft.faces.webapp.http.core.MultiViewServer;
import com.icesoft.faces.webapp.http.core.PageTest;
import com.icesoft.faces.webapp.http.core.PushServerDetector;
import com.icesoft.faces.webapp.http.core.ReceivePing;
import com.icesoft.faces.webapp.http.core.ReceiveSendUpdates;
import com.icesoft.faces.webapp.http.core.RequestVerifier;
import com.icesoft.faces.webapp.http.core.ResourceDispatcher;
import com.icesoft.faces.webapp.http.core.SendUpdates;
import com.icesoft.faces.webapp.http.core.SingleViewServer;
import com.icesoft.faces.webapp.http.core.UploadServer;
import com.icesoft.faces.webapp.http.core.ViewQueue;
import com.icesoft.faces.webapp.http.servlet.DisposeViewsHandler;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import com.icesoft.net.messaging.MessageServiceClient;
import com.icesoft.util.IdGenerator;
import com.icesoft.util.MonitorRunner;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MainSessionBoundServlet
implements Server,
PageTest {
    private static final Log Log = LogFactory.getLog((Class)MainSessionBoundServlet.class);
    private static final String ResourcePrefix = "/block/resource/";
    private static final String ResourceRegex = ".*" + "/block/resource/".replaceAll("\\/", "\\/") + ".*";
    private static final SessionExpired SessionExpired = new SessionExpired();
    private static final Server OKServer = new ResponseHandlerServer(OKResponse.Handler);
    private static final Runnable NOOP = new Runnable(){

        public void run() {
        }
    };
    private final Runnable drainUpdatedViews = new Runnable(){

        public void run() {
            MainSessionBoundServlet.this.allUpdatedViews.removeAll(MainSessionBoundServlet.this.synchronouslyUpdatedViews);
            if (!MainSessionBoundServlet.this.allUpdatedViews.isEmpty()) {
                Log.warn((Object)((Object)((Object)MainSessionBoundServlet.this.allUpdatedViews) + " views have accumulated updates"));
            }
            MainSessionBoundServlet.this.allUpdatedViews.clear();
        }
    };
    private final Map views = Collections.synchronizedMap(new HashMap());
    private final ViewQueue allUpdatedViews = new ViewQueue();
    private final Collection synchronouslyUpdatedViews = new HashSet();
    private final PathDispatcherServer dispatcher = new PathDispatcherServer();
    private final String sessionID;
    private boolean pageLoaded = false;
    private Runnable shutdown;

    public MainSessionBoundServlet(final HttpSession session, SessionDispatcher.Monitor sessionMonitor, IdGenerator idGenerator, MimeTypeMatcher mimeTypeMatcher, MonitorRunner monitorRunner, Configuration configuration, final MessageServiceClient messageService, String blockingRequestHandlerContext, Authorization authorization) {
        Server receivePing;
        Server sendUpdates;
        Server sendUpdatedViews;
        DisposeViewsHandler handler;
        Server disposeViews;
        Server viewServlet;
        this.sessionID = MainSessionBoundServlet.restoreOrCreateSessionID(session, idGenerator);
        ContextEventRepeater.iceFacesIdRetrieved(session, this.sessionID);
        ResourceDispatcher resourceDispatcher = new ResourceDispatcher(ResourcePrefix, mimeTypeMatcher, sessionMonitor, configuration);
        if (configuration.getAttributeAsBoolean("concurrentDOMViews", false)) {
            viewServlet = new MultiViewServer(session, this.sessionID, sessionMonitor, this.views, this.allUpdatedViews, configuration, resourceDispatcher, blockingRequestHandlerContext, authorization);
            if (messageService == null) {
                disposeViews = new DisposeViews(this.sessionID, this.views);
                handler = null;
            } else {
                disposeViews = OKServer;
                handler = new DisposeViewsHandler();
                handler.setCallback(new DisposeViewsHandler.Callback(){

                    public void disposeView(String sessionIdentifier, String viewIdentifier) {
                        View view;
                        if (MainSessionBoundServlet.this.sessionID.equals(sessionIdentifier) && (view = (View)MainSessionBoundServlet.this.views.remove(viewIdentifier)) != null) {
                            view.dispose();
                        }
                    }
                });
                messageService.addMessageHandler(handler, "icefacesPush");
            }
        } else {
            viewServlet = new SingleViewServer(session, this.sessionID, sessionMonitor, this.views, this.allUpdatedViews, configuration, resourceDispatcher, blockingRequestHandlerContext, authorization);
            disposeViews = OKServer;
            handler = null;
        }
        if (configuration.getAttributeAsBoolean("synchronousUpdate", false)) {
            this.allUpdatedViews.onPut(this.drainUpdatedViews);
            sendUpdatedViews = OKServer;
            sendUpdates = OKServer;
            receivePing = OKServer;
        } else {
            sendUpdatedViews = new RequestVerifier(this.sessionID, new PushServerDetector(this.sessionID, this.synchronouslyUpdatedViews, this.allUpdatedViews, monitorRunner, configuration, messageService, this));
            sendUpdates = new RequestVerifier(this.sessionID, new SendUpdates(configuration, this.views));
            receivePing = new RequestVerifier(this.sessionID, new ReceivePing(this.views));
        }
        UploadServer upload = new UploadServer(this.views, configuration);
        RequestVerifier receiveSendUpdates = new RequestVerifier(this.sessionID, new ReceiveSendUpdates(this.views, this.synchronouslyUpdatedViews, sessionMonitor));
        this.dispatcher.dispatchOn(".*block\\/send\\-receive\\-updates$", receiveSendUpdates);
        this.dispatcher.dispatchOn(".*block\\/receive\\-updated\\-views$", sendUpdatedViews);
        this.dispatcher.dispatchOn(".*block\\/receive\\-updates$", sendUpdates);
        this.dispatcher.dispatchOn(".*block\\/ping$", receivePing);
        this.dispatcher.dispatchOn(".*block\\/dispose\\-views$", disposeViews);
        this.dispatcher.dispatchOn(ResourceRegex, resourceDispatcher);
        this.dispatcher.dispatchOn(".*uploadHtml", upload);
        this.dispatcher.dispatchOn(".*", new ServerProxy(viewServlet){

            public void service(Request request) throws Exception {
                MainSessionBoundServlet.this.pageLoaded = true;
                super.service(request);
            }
        });
        this.shutdown = new Runnable(){

            public void run() {
                MainSessionBoundServlet.this.shutdown = NOOP;
                DisposeBeans.in(session);
                Iterator i = MainSessionBoundServlet.this.views.values().iterator();
                while (i.hasNext()) {
                    CommandQueue commandQueue = (CommandQueue)i.next();
                    commandQueue.put(SessionExpired);
                }
                ContextEventRepeater.iceFacesIdDisposed(session, MainSessionBoundServlet.this.sessionID);
                MainSessionBoundServlet.this.dispatcher.shutdown();
                Iterator viewIterator = MainSessionBoundServlet.this.views.values().iterator();
                while (viewIterator.hasNext()) {
                    View view = (View)viewIterator.next();
                    view.dispose();
                }
                if (handler != null) {
                    messageService.removeMessageHandler(handler, "icefacesPush");
                }
            }
        };
    }

    private static String restoreOrCreateSessionID(HttpSession session, IdGenerator idGenerator) {
        String key = MainSessionBoundServlet.class.getName();
        Object o = session.getAttribute(key);
        if (o == null) {
            String id = idGenerator.newIdentifier();
            session.setAttribute(key, (Object)id);
            return id;
        }
        return (String)o;
    }

    public void service(Request request) throws Exception {
        this.dispatcher.service(request);
    }

    public void shutdown() {
        this.shutdown.run();
    }

    public boolean isLoaded() {
        return this.pageLoaded;
    }

    public Map getViews() {
        return this.views;
    }

    public ViewQueue getAllUpdatedViews() {
        return this.allUpdatedViews;
    }

    public Collection getSynchronouslyUpdatedViews() {
        return this.synchronouslyUpdatedViews;
    }

    public String getSessionID() {
        return this.sessionID;
    }
}

