/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Response;
import com.icesoft.faces.webapp.http.common.ResponseHandler;
import com.icesoft.faces.webapp.http.portlet.PortletArtifactWrapper;
import com.icesoft.jasper.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.portlet.PortletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServletRequestResponse
implements Request,
Response {
    private static final Log log = LogFactory.getLog((Class)ServletRequestResponse.class);
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
    private static Pattern HEADER_FIXER = null;
    private URI requestURI;
    protected HttpServletRequest request;
    protected HttpServletResponse response;

    public ServletRequestResponse(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.request = request;
        this.response = response;
        this.detectEnvironment(new Request.Environment(){

            public void servlet(Object request, Object response) {
                HttpServletRequest req = (HttpServletRequest)request;
                String query = req.getQueryString();
                URI uri = null;
                while (null == uri) {
                    try {
                        uri = URI.create(req.getRequestURL().toString());
                    }
                    catch (NullPointerException e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Null Protocol Scheme in request", (Throwable)e);
                        }
                        uri = URI.create("http://" + req.getServerName() + ":" + req.getServerPort() + req.getRequestURI());
                    }
                }
                ServletRequestResponse.this.requestURI = query == null ? uri : URI.create(uri + "?" + query);
            }

            public void portlet(Object request, Object response, Object portletConfig) {
                PortletRequest req = (PortletRequest)request;
                String reqURI = (String)req.getAttribute("javax.servlet.include.request_uri");
                ServletRequestResponse.this.requestURI = URI.create(reqURI);
            }
        });
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public URI getURI() {
        return this.requestURI;
    }

    public String[] getHeaderNames() {
        ArrayList headerNames = new ArrayList();
        Enumeration e = this.request.getHeaderNames();
        while (e.hasMoreElements()) {
            headerNames.add(e.nextElement());
        }
        return headerNames.toArray(new String[headerNames.size()]);
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public String[] getHeaderAsStrings(String name) {
        Enumeration e = this.request.getHeaders(name);
        ArrayList values = new ArrayList();
        while (e.hasMoreElements()) {
            values.add(e.nextElement());
        }
        return values.toArray(new String[values.size()]);
    }

    public Date getHeaderAsDate(String name) {
        try {
            return DATE_FORMAT.parse(this.request.getHeader(name));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public int getHeaderAsInteger(String name) {
        return Integer.parseInt(this.request.getHeader(name));
    }

    public boolean containsParameter(String name) {
        return this.request.getParameter(name) != null;
    }

    public String[] getParameterNames() {
        Set result = this.request.getParameterMap().keySet();
        return result.toArray(new String[result.size()]);
    }

    public String getParameter(String name) {
        this.checkExistenceOf(name);
        return this.request.getParameter(name);
    }

    public String[] getParameterAsStrings(String name) {
        this.checkExistenceOf(name);
        return this.request.getParameterValues(name);
    }

    public int getParameterAsInteger(String name) {
        return Integer.parseInt(this.getParameter(name));
    }

    public boolean getParameterAsBoolean(String name) {
        return Boolean.valueOf(this.getParameter(name));
    }

    public String getParameter(String name, String defaultValue) {
        try {
            return this.getParameter(name);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int getParameterAsInteger(String name, int defaultValue) {
        try {
            return this.getParameterAsInteger(name);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public boolean getParameterAsBoolean(String name, boolean defaultValue) {
        try {
            return this.getParameterAsBoolean(name);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String getLocalAddr() {
        return this.request.getLocalAddr();
    }

    public String getLocalName() {
        return this.request.getLocalName();
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public InputStream readBody() throws IOException {
        return this.request.getInputStream();
    }

    public void readBodyInto(OutputStream out) throws IOException {
        ServletRequestResponse.copy(this.readBody(), out);
    }

    public void respondWith(ResponseHandler handler) throws Exception {
        handler.respond(this);
    }

    public void setStatus(int code) {
        this.response.setStatus(code);
    }

    public void setHeader(String name, String value) {
        if (ServletRequestResponse.ignoreHeader(name, value)) {
            return;
        }
        value = HEADER_FIXER.matcher(value).replaceAll("");
        if ("Content-Type".equals(name)) {
            this.response.setContentType(value);
        } else if ("Content-Length".equals(name)) {
            this.response.setContentLength(Integer.parseInt(value));
        } else {
            this.response.setHeader(name, value);
        }
    }

    public void setHeader(String name, String[] values) {
        if (ServletRequestResponse.ignoreHeader(name, values)) {
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            String safeValue = HEADER_FIXER.matcher(values[i]).replaceAll("");
            this.response.addHeader(name, safeValue);
        }
    }

    public void setHeader(String name, Date value) {
        if (ServletRequestResponse.ignoreHeader(name, value)) {
            return;
        }
        this.response.setDateHeader(name, value.getTime());
    }

    public void setHeader(String name, int value) {
        this.response.setIntHeader(name, value);
    }

    public void setHeader(String name, long value) {
        this.response.setHeader(name, String.valueOf(value));
    }

    public void addCookie(Cookie cookie) {
        this.response.addCookie(cookie);
    }

    public OutputStream writeBody() throws IOException {
        return this.response.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBodyFrom(InputStream in) throws IOException {
        try {
            ServletRequestResponse.copy(in, this.writeBody());
        }
        finally {
            in.close();
        }
    }

    public void detectEnvironment(Request.Environment environment) throws Exception {
        Object portletEnvironment = this.request.getAttribute("com.icesoft.faces.portlet.artifact");
        if (portletEnvironment == null) {
            environment.servlet(this.request, this.response);
        } else {
            PortletArtifactWrapper portletArtifact = (PortletArtifactWrapper)portletEnvironment;
            environment.portlet(portletArtifact.getRequest(), portletArtifact.getResponse(), portletArtifact.getPortletConfig());
            String[] incKeys = Constants.INC_CONSTANTS;
            for (int index = 0; index < incKeys.length; ++index) {
                String incVal = (String)this.request.getAttribute(incKeys[index]);
                if (incVal != null) {
                    portletArtifact.getRequest().setAttribute(incKeys[index], (Object)incVal);
                    continue;
                }
                portletArtifact.getRequest().removeAttribute(incKeys[index]);
            }
        }
    }

    private static void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buf = new byte[4096];
        int len = 0;
        while ((len = input.read(buf)) > -1) {
            output.write(buf, 0, len);
        }
    }

    private void checkExistenceOf(String name) {
        if (this.request.getParameter(name) == null) {
            String host = this.request.getRemoteHost();
            StringBuffer data = new StringBuffer("+ Request does not contain parameter '" + name + "' host: \n");
            data.append("  Originator: ").append(host).append("\n");
            data.append("  Path: ").append(this.requestURI.toString()).append("\n");
            Enumeration e = this.request.getParameterNames();
            int i = 0;
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (i == 0) {
                    data.append("  Available request parameters are: \n");
                }
                data.append("  - parameter name: ").append(key).append(", value: ").append(this.request.getParameter(key)).append("\n");
                ++i;
            }
            if (i == 0) {
                data.append("   Request map is empty!\n");
            }
            data.append("- SRR hashcode: ").append(this.hashCode()).append(" Servlet request hash: ").append(this.request.hashCode());
            log.debug((Object)data.toString());
            throw new RuntimeException("Query does not contain parameter named: " + name);
        }
    }

    private static boolean ignoreHeader(String name, Object value) {
        return name == null || value == null;
    }

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        HEADER_FIXER = Pattern.compile("[\r\n]");
    }
}

