/*
 * Decompiled with CFR 0.152.
 */
package org.icepear.echarts.render;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import java.awt.Desktop;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.icepear.echarts.Chart;
import org.icepear.echarts.Option;
import org.icepear.echarts.render.ChartMeta;
import org.icepear.echarts.serializer.EChartsSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Engine {
    private static final Logger log = LoggerFactory.getLogger(Engine.class);
    private Handlebars handlebars = new Handlebars();

    private void writeHtml(String html, String path, Boolean willOpen) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(path));
            writer.write(html);
            writer.close();
            if (willOpen.booleanValue()) {
                File file = new File(path);
                Desktop.getDesktop().browse(file.toURI());
            }
        }
        catch (IOException e) {
            log.info("Write Html failed. Path error.");
        }
    }

    public void render(String path, Chart<?, ?> chart) {
        String jsonStr = EChartsSerializer.toJson(chart.getOption());
        ChartMeta chartMeta = new ChartMeta("600px", "600px", jsonStr);
        try {
            Template template = this.handlebars.compile("index");
            String html = template.apply((Object)chartMeta);
            this.writeHtml(html, path, false);
        }
        catch (IOException e) {
            log.info("render: Handlebars cannot find corresponding templates.");
        }
    }

    public void render(String path, Option option) {
        String jsonStr = EChartsSerializer.toJson(option);
        ChartMeta chartMeta = new ChartMeta("600px", "600px", jsonStr);
        try {
            Template template = this.handlebars.compile("index");
            String html = template.apply((Object)chartMeta);
            this.writeHtml(html, path, false);
        }
        catch (IOException e) {
            log.info("render: Handlebars cannot find corresponding templates.");
        }
    }

    public void render(String path, Chart<?, ?> chart, String height, String width, Boolean willOpen) {
        String jsonStr = EChartsSerializer.toJson(chart.getOption());
        ChartMeta chartMeta = new ChartMeta(height, width, jsonStr);
        try {
            Template template = this.handlebars.compile("index");
            String html = template.apply((Object)chartMeta);
            this.writeHtml(html, path, willOpen);
        }
        catch (IOException e) {
            log.info("render: Handlebars cannot find corresponding templates.");
        }
    }

    public void render(String path, Option option, String height, String width, Boolean willOpen) {
        String jsonStr = EChartsSerializer.toJson(option);
        ChartMeta chartMeta = new ChartMeta(height, width, jsonStr);
        try {
            Template template = this.handlebars.compile("index");
            String html = template.apply((Object)chartMeta);
            this.writeHtml(html, path, willOpen);
        }
        catch (IOException e) {
            log.info("render: Handlebars cannot find corresponding templates.");
        }
    }

    public String renderHtml(Chart<?, ?> chart) {
        String jsonStr = EChartsSerializer.toJson(chart.getOption());
        ChartMeta chartMeta = new ChartMeta("100%", "100%", jsonStr);
        Template template = null;
        try {
            template = this.handlebars.compile("base");
            return template.apply((Object)chartMeta);
        }
        catch (IOException e) {
            log.info("renderHtml: Handlebars cannot find corresponding templates.");
            return "";
        }
    }

    public String renderHtml(Option option) {
        String jsonStr = EChartsSerializer.toJson(option);
        ChartMeta chartMeta = new ChartMeta("100%", "100%", jsonStr);
        Template template = null;
        try {
            template = this.handlebars.compile("base");
            return template.apply((Object)chartMeta);
        }
        catch (IOException e) {
            log.info("renderHtml: Handlebars cannot find corresponding templates.");
            return "";
        }
    }

    public String renderHtml(Chart<?, ?> chart, String height, String width) {
        String jsonStr = EChartsSerializer.toJson(chart.getOption());
        ChartMeta chartMeta = new ChartMeta(height, width, jsonStr);
        try {
            Template template = this.handlebars.compile("base");
            return template.apply((Object)chartMeta);
        }
        catch (IOException e) {
            log.info("renderHtml: Handlebars cannot find corresponding templates.");
            return "";
        }
    }

    public String renderHtml(Option option, String height, String width) {
        String jsonStr = EChartsSerializer.toJson(option);
        ChartMeta chartMeta = new ChartMeta(height, width, jsonStr);
        try {
            Template template = this.handlebars.compile("base");
            return template.apply((Object)chartMeta);
        }
        catch (IOException e) {
            log.info("renderHtml: Handlebars cannot find corresponding templates.");
            return "";
        }
    }

    public String renderJsonOption(Chart<?, ?> chart) {
        return EChartsSerializer.toJson(chart.getOption());
    }

    public String renderJsonOption(Option option) {
        return EChartsSerializer.toJson(option);
    }
}

