/*
 * Decompiled with CFR 0.152.
 */
package org.icepear.echarts.render;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import java.awt.Desktop;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.icepear.echarts.Chart;
import org.icepear.echarts.Option;
import org.icepear.echarts.render.ChartMeta;
import org.icepear.echarts.serializer.EChartsSerializer;
import org.icepear.echarts.serializer.EChartsTypeAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Engine {
    private static final Logger log = LoggerFactory.getLogger(Engine.class);
    private Handlebars handlebars = new Handlebars();

    private void writeHtml(String html, String path, Boolean willOpen) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(path));
            writer.write(html);
            writer.close();
            if (willOpen.booleanValue()) {
                File file = new File(path);
                Desktop.getDesktop().browse(file.toURI());
            }
        }
        catch (IOException e) {
            log.info("Write Html failed. Path error.");
        }
    }

    private String compileHandleBars(String templateName, Option option, String height, String width) {
        String jsonStr = new EChartsSerializer(new EChartsTypeAdapter[0]).toJson(option);
        ChartMeta chartMeta = new ChartMeta(height, width, jsonStr);
        String html = "";
        try {
            Template template = this.handlebars.compile("index");
            html = template.apply((Object)chartMeta);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return html;
    }

    public void render(String path, Chart<?, ?> chart) {
        this.render(path, chart.getOption());
    }

    public void render(String path, Option option) {
        this.render(path, option, "600px", "600px", (Boolean)false);
    }

    public void render(String path, Chart<?, ?> chart, String height, String width, Boolean willOpen) {
        this.render(path, chart.getOption(), height, width, willOpen);
    }

    public void render(String path, Option option, String height, String width, Boolean willOpen) {
        String html = this.compileHandleBars("index", option, height, width);
        this.writeHtml(html, path, willOpen);
    }

    public String renderHtml(Chart<?, ?> chart) {
        return this.renderHtml(chart.getOption());
    }

    public String renderHtml(Option option) {
        return this.renderHtml(option, "100%", "100%");
    }

    public String renderHtml(Chart<?, ?> chart, String height, String width) {
        return this.renderHtml(chart.getOption(), "100%", "100%");
    }

    public String renderHtml(Option option, String height, String width) {
        return this.compileHandleBars("base", option, height, width);
    }

    public String renderJsonOption(Chart<?, ?> chart) {
        return this.renderJsonOption(chart.getOption());
    }

    public String renderJsonOption(Option option) {
        return new EChartsSerializer(new EChartsTypeAdapter[0]).toJson(option);
    }
}

