/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.nio.file.Path;
import java.util.Objects;
import org.icij.datashare.text.PathDeserializer;
import org.icij.datashare.text.PathSerializer;
import org.icij.datashare.text.Project;

public class Note {
    public final Project project;
    public final String note;
    @JsonSerialize(using=PathSerializer.class)
    @JsonDeserialize(using=PathDeserializer.class)
    public final Path path;
    public final Variant variant;

    public Note(Project project, Path path, String note) {
        this(project, path, note, Variant.info);
    }

    @JsonCreator
    public Note(@JsonProperty(value="project") Project project, @JsonProperty(value="path") Path path, @JsonProperty(value="note") String note, @JsonProperty(value="variant") Variant variant) {
        this.project = project;
        this.note = note;
        this.path = path;
        this.variant = variant;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Note note = (Note)o;
        return this.project.equals(note.project) && this.path.equals(note.path);
    }

    public int hashCode() {
        return Objects.hash(this.project, this.path);
    }

    public String toString() {
        return "Note{project=" + this.project.name + ", path=" + this.path + "}";
    }

    public static enum Variant {
        dark,
        light,
        danger,
        info,
        success,
        warning,
        primary,
        secondary;

    }
}

