/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesProvider {
    public static final String PLUGINS_DIR = "pluginsDir";
    public static final String EXTENSIONS_DIR = "extensionsDir";
    public static final String TCP_LISTEN_PORT = "tcpListenPort";
    private static final String PREFIX = "DS_DOCKER_";
    private static final String DEFAULT_DATASHARE_PROPERTIES_FILE_NAME = "datashare.properties";
    public static final String SETTINGS_FILE_PARAMETER_KEY = "settings";
    public static final String QUEUE_NAME_OPTION = "queueName";
    public static final String SET_NAME_OPTION = "filterSet";
    public static final String MAP_NAME_OPTION = "reportName";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Path settingsPath;
    private volatile Properties cachedProperties;

    public PropertiesProvider() {
        this((String)null);
    }

    public PropertiesProvider(String fileName) {
        this.settingsPath = this.getFilePath(fileName);
    }

    public PropertiesProvider(Properties properties) {
        this.cachedProperties = properties;
        this.settingsPath = null;
    }

    public PropertiesProvider(Map<String, String> hashMap) {
        this.cachedProperties = PropertiesProvider.fromMap(hashMap);
        this.settingsPath = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties() {
        if (this.cachedProperties == null) {
            PropertiesProvider propertiesProvider = this;
            synchronized (propertiesProvider) {
                if (this.cachedProperties == null) {
                    Properties localProperties = new Properties();
                    try {
                        FileInputStream propertiesStream = new FileInputStream(this.settingsPath.toFile());
                        this.logger.info("reading properties from {}", (Object)this.settingsPath);
                        localProperties.load(propertiesStream);
                    }
                    catch (IOException | NullPointerException e) {
                        this.logger.warn("no {} file found, using default values", (Object)this.settingsPath);
                    }
                    this.loadEnvVariables(localProperties);
                    this.cachedProperties = localProperties;
                    this.logger.info("properties set to {}", (Object)this.cachedProperties);
                }
            }
        }
        return this.cachedProperties;
    }

    private void loadEnvVariables(Properties properties) {
        Map<String, String> envVars = System.getenv().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(PREFIX)).collect(Collectors.toMap(k -> this.camelCasify(((String)k.getKey()).replace(PREFIX, "")), Map.Entry::getValue));
        this.logger.info("adding properties from env vars {}", envVars);
        properties.putAll(envVars);
    }

    private String camelCasify(String str) {
        String[] stringParts = str.toLowerCase().split("_");
        return stringParts[0] + Arrays.stream(stringParts).skip(1L).map(s -> Character.toUpperCase(s.charAt(0)) + s.substring(1)).collect(Collectors.joining());
    }

    public Optional<String> get(String propertyName) {
        return this.getProperties().getProperty(propertyName) == null ? Optional.empty() : Optional.of(this.getProperties().getProperty(propertyName));
    }

    public PropertiesProvider mergeWith(Properties properties) {
        this.putAllIfIsAbsent(this.getProperties(), properties);
        this.logger.info("merged properties (without override) with {}", (Object)properties);
        return this;
    }

    public PropertiesProvider overrideWith(Properties properties) {
        this.logger.info("overriding properties with {}", (Object)properties);
        this.getProperties().putAll((Map<?, ?>)properties);
        return this;
    }

    public Properties createOverriddenWith(Map<String, String> map) {
        Properties overriddenProperties = (Properties)this.getProperties().clone();
        overriddenProperties.putAll(map);
        return overriddenProperties;
    }

    public Properties createMerged(Properties properties) {
        Properties mergedProperties = (Properties)this.getProperties().clone();
        this.putAllIfIsAbsent(mergedProperties, properties);
        return mergedProperties;
    }

    public Map<String, Object> getFilteredProperties(String ... excludedKeyPatterns) {
        return this.getProperties().entrySet().stream().filter(e -> Arrays.stream(excludedKeyPatterns).noneMatch(s -> Pattern.matches(s, (String)e.getKey()))).collect(Collectors.toMap(e -> (String)e.getKey(), Map.Entry::getValue));
    }

    public void save() throws IOException {
        this.logger.info("writing properties to file {}", (Object)this.settingsPath);
        if (this.settingsPath == null) {
            throw new SettingsNotFound();
        }
        Properties toSave = new Properties();
        toSave.putAll(this.getFilteredProperties("user.*"));
        toSave.store(new FileOutputStream(this.settingsPath.toFile()), "Datashare properties");
    }

    public static Properties fromMap(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        Properties properties = new Properties();
        properties.putAll(map);
        return properties;
    }

    private void putAllIfIsAbsent(Properties dest, Properties propertiesToMerge) {
        for (Map.Entry<Object, Object> entry : propertiesToMerge.entrySet()) {
            dest.putIfAbsent(entry.getKey(), entry.getValue());
        }
    }

    private Path getFilePath(String fileName) {
        Path path;
        if (fileName == null) {
            URL url = Thread.currentThread().getContextClassLoader().getResource(DEFAULT_DATASHARE_PROPERTIES_FILE_NAME);
            if (url == null) {
                return null;
            }
            path = Paths.get(url.getPath(), new String[0]);
        } else {
            path = Paths.get(fileName, new String[0]);
        }
        return this.isFileReadable(path) ? path : null;
    }

    boolean isFileReadable(Path filePath) {
        if (filePath.toFile().exists()) {
            if (!filePath.toFile().canWrite()) {
                this.logger.warn("{} is not writable. The settings file won't be able to be saved", (Object)filePath);
            }
            return true;
        }
        try {
            filePath.toFile().createNewFile();
            filePath.toFile().delete();
            return true;
        }
        catch (IOException e) {
            this.logger.warn("{} is not writable. The settings file won't be able to be saved", (Object)filePath);
            return false;
        }
    }

    public static class SettingsNotFound
    extends RuntimeException {
        SettingsNotFound() {
            super("cannot find settings file");
        }
    }
}

