/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.text;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.icij.datashare.text.Document;
import org.icij.datashare.text.Language;
import org.icij.datashare.text.Project;
import org.icij.datashare.text.Tag;
import org.icij.datashare.text.nlp.Pipeline;

public class DocumentBuilder {
    private String id;
    private String content;
    private List<Map<String, String>> content_translated;
    private Path path;
    private Map<String, Object> metadata = new HashMap<String, Object>();
    private String mimeType;
    private Set<Pipeline.Type> pipelines;
    private String parentId = null;
    private String rootId = null;
    private Set<Tag> tags;
    private Project project;
    private Language language = Language.ENGLISH;
    private short extractionLevel;
    private Charset charset;
    private Document.Status documentStatus;
    private Date extractionDate;
    private Long contentLength;

    private DocumentBuilder() {
    }

    public static DocumentBuilder createDoc() {
        return new DocumentBuilder();
    }

    public static DocumentBuilder createDoc(String id) {
        return new DocumentBuilder().withDefaultValues(id);
    }

    public static DocumentBuilder createDoc(Project project, Path path) {
        return new DocumentBuilder().withDefaultValues(Document.getHash(project, path)).with(project).with(path);
    }

    public DocumentBuilder withDefaultValues(String id) {
        this.id = id;
        this.charset = Charset.defaultCharset();
        this.content = id;
        this.contentLength = this.content.getBytes(this.charset).length;
        this.documentStatus = Document.Status.INDEXED;
        this.extractionDate = new Date();
        this.extractionLevel = 0;
        this.path = Paths.get("/path/to/", new String[0]).resolve(id);
        this.mimeType = "text/plain";
        this.pipelines = new HashSet<Pipeline.Type>();
        this.project = Project.project("prj");
        this.tags = new HashSet<Tag>();
        return this;
    }

    public DocumentBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public DocumentBuilder with(String content) {
        this.content = content;
        return this;
    }

    public DocumentBuilder with(Path path) {
        this.path = path;
        return this;
    }

    public DocumentBuilder with(Language language) {
        this.language = language;
        return this;
    }

    public DocumentBuilder with(Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }

    public DocumentBuilder with(List<Map<String, String>> contentTranslated) {
        this.content_translated = contentTranslated;
        return this;
    }

    public DocumentBuilder ofMimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    public DocumentBuilder with(Charset charset) {
        this.charset = charset;
        return this;
    }

    public DocumentBuilder extractedAt(Date extractionDate) {
        this.extractionDate = extractionDate;
        return this;
    }

    public DocumentBuilder with(Pipeline.Type ... pipelineTypes) {
        this.pipelines = Arrays.stream(pipelineTypes).collect(Collectors.toSet());
        return this;
    }

    public DocumentBuilder with(Document.Status documentStatus) {
        this.documentStatus = documentStatus;
        return this;
    }

    public DocumentBuilder with(Project project) {
        this.project = project;
        return this;
    }

    public DocumentBuilder with(Tag ... tags) {
        this.tags = Arrays.stream(tags).collect(Collectors.toSet());
        return this;
    }

    public DocumentBuilder withExtractionLevel(short extractionLevel) {
        this.extractionLevel = extractionLevel;
        return this;
    }

    public DocumentBuilder withContentLength(long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public DocumentBuilder withRootId(String rootId) {
        this.rootId = rootId;
        return this;
    }

    public DocumentBuilder withParentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    public Document build() {
        if (this.id == null && this.project == null && this.path == null && this.content == null) {
            throw new NullPointerException("Id, Project, Path or content are missing.");
        }
        return new Document(this.project, this.id, this.path, this.content, this.content_translated, this.language, this.charset, this.mimeType, this.metadata, this.documentStatus, this.pipelines, this.extractionDate, this.rootId, this.parentId, this.extractionLevel, this.contentLength, this.tags);
    }
}

