/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.text;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.Optional;
import org.icij.datashare.Entity;
import org.icij.datashare.text.indexing.IndexId;
import org.icij.datashare.text.indexing.IndexType;

@IndexType(value="SourcePath")
public class SourcePath
implements Entity {
    private static final long serialVersionUID = 1587956432685458L;
    private Path path;
    private Date asOf;
    @IndexId
    @JsonIgnore
    private String hash;

    public static Optional<SourcePath> create(Path path) {
        try {
            return Optional.of(new SourcePath(path));
        }
        catch (IllegalStateException e) {
            LOGGER.error("Failed to create document", (Throwable)e);
            return Optional.empty();
        }
    }

    private SourcePath() {
    }

    private SourcePath(Path path) throws IllegalArgumentException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IllegalArgumentException("File " + path + " does not exist.");
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new IllegalArgumentException("File " + path + " is not a regular file.");
        }
        if (!Files.isReadable(path)) {
            throw new IllegalArgumentException("File " + path + " is not readable.");
        }
        this.path = path;
        this.hash = HASHER.hash(this.getPath().toString());
        this.asOf = new Date();
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public String getId() {
        return this.hash;
    }

    public Date getAsOf() {
        return this.asOf;
    }

    public String toString() {
        return this.getPath() + "(" + this.getId() + ")";
    }
}

