/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.icij.datashare.PropertiesProvider;
import org.icij.datashare.Stage;

public class PipelineHelper {
    public static final String STAGES_OPT = "stages";
    public static final char STAGES_SEPARATOR = ',';
    private final PropertiesProvider propertiesProvider;
    public final List<Stage> stages;

    public PipelineHelper(PropertiesProvider propertiesProvider) {
        this.propertiesProvider = propertiesProvider;
        this.stages = Arrays.stream(propertiesProvider.get(STAGES_OPT).orElse("SCAN,INDEX,NLP").split(String.valueOf(','))).map(Stage::valueOf).collect(Collectors.toList());
        this.stages.sort(Stage.comparator);
    }

    public boolean has(Stage stage) {
        return this.stages.contains((Object)stage);
    }

    public String getQueueNameFor(Stage stage) {
        return stage.isFirstEnum() ? null : PipelineHelper.getQueueName(this.propertiesProvider, stage);
    }

    public String getOutputQueueNameFor(Stage stage) {
        return stage.isLastEnum() ? null : PipelineHelper.getQueueName(this.propertiesProvider, this.getNextStage(stage));
    }

    private Stage getNextStage(Stage stage) {
        if (stage == this.stages.get(this.stages.size() - 1)) {
            return stage.getDefaultNextStage();
        }
        if (!this.stages.contains((Object)stage)) {
            return stage.getDefaultNextStage();
        }
        return this.stages.get(this.stages.indexOf((Object)stage) + 1);
    }

    static String getQueueName(PropertiesProvider propertiesProvider, Stage stage) {
        return PipelineHelper.getInputQueueName(propertiesProvider) + ":" + stage.name().toLowerCase();
    }

    static String getInputQueueName(PropertiesProvider propertiesProvider) {
        return propertiesProvider.get("queueName").orElse("extract:queue");
    }
}

