/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare;

import java.util.Comparator;
import java.util.Locale;
import java.util.Optional;

public enum Stage {
    SCAN(true),
    SCANIDX(false),
    DEDUPLICATE(false),
    INDEX(true),
    ENQUEUEIDX(false),
    NLP(true);

    public static final Comparator<Stage> comparator;
    private final boolean isMainStage;

    private Stage(boolean isMain) {
        this.isMainStage = isMain;
    }

    public static Optional<Stage> parse(String stage) {
        if (stage == null || stage.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(Stage.valueOf(stage.toUpperCase(Locale.ROOT)));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public boolean isFirstEnum() {
        return this.ordinal() == 0;
    }

    public boolean isLastEnum() {
        return this.ordinal() == Stage.values().length;
    }

    public Stage getDefaultNextStage() {
        Stage[] stages = Stage.values();
        for (int i = this.ordinal() + 1; i < stages.length; ++i) {
            if (!stages[i].isMainStage) continue;
            return stages[i];
        }
        return NLP;
    }

    static {
        comparator = Comparator.comparing(Enum::ordinal);
    }
}

