/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.batch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.icij.datashare.text.Project;
import org.icij.datashare.text.indexing.SearchQuery;
import org.icij.datashare.time.DatashareTime;
import org.icij.datashare.user.User;

public class BatchDownload {
    public static final String ZIP_FORMAT = "archive_%s_%s.zip";
    public final String uuid;
    public final List<Project> projects;
    public final Path filename;
    public final String uri;
    public final User user;
    public final boolean encrypted;
    public final SearchQuery query;

    public BatchDownload(List<Project> projects, User user, String query, String uri) {
        this(projects, user, query, uri, Paths.get(System.getProperty("java.io.tmpdir"), new String[0]), false);
    }

    public BatchDownload(List<Project> projects, User user, String query) {
        this(projects, user, query, null, Paths.get(System.getProperty("java.io.tmpdir"), new String[0]), false);
    }

    public BatchDownload(List<Project> projects, User user, String query, String uri, Path downloadDir, boolean isEncrypted) {
        this(UUID.randomUUID().toString(), projects, downloadDir.resolve(BatchDownload.createFilename(user)), new SearchQuery(Optional.ofNullable(query).orElseThrow(() -> new IllegalArgumentException("query cannot be null"))), uri, user, isEncrypted);
    }

    @JsonCreator
    BatchDownload(@JsonProperty(value="uuid") String uuid, @JsonProperty(value="projects") List<Project> projects, @JsonProperty(value="filename") Path filename, @JsonProperty(value="query") SearchQuery query, @JsonProperty(value="uri") String uri, @JsonProperty(value="user") User user, @JsonProperty(value="encrypted") boolean encrypted) {
        this.query = Optional.ofNullable(query).orElseThrow(() -> new IllegalArgumentException("query cannot be null or empty"));
        if (query.isNull() || query.isJsonQuery() && query.asJson() == null) {
            throw new IllegalArgumentException("invalid query: " + query);
        }
        this.uuid = uuid;
        this.projects = Collections.unmodifiableList(Optional.ofNullable(projects).orElse(new ArrayList()));
        this.user = user;
        this.uri = uri;
        this.filename = filename;
        this.encrypted = encrypted;
    }

    public static Path createFilename(User user) {
        User nonNullUser = Optional.ofNullable(user).orElseThrow(() -> new IllegalArgumentException("user cannot be null or empty"));
        String strTime = DateTimeFormatter.ISO_DATE_TIME.format(ZonedDateTime.from(DatashareTime.getInstance().now().toInstant().atZone(ZoneId.of("GMT")))).replace(":", "_");
        return Paths.get(String.format(ZIP_FORMAT, nonNullUser.getId(), strTime), new String[0]);
    }

    public boolean getExists() {
        return Files.exists(this.filename, new LinkOption[0]);
    }

    @JsonIgnore
    public boolean isJsonQuery() {
        return this.query.isJsonQuery();
    }

    public JsonNode queryAsJson() {
        return this.query.asJson();
    }

    public String toString() {
        return "BatchDownload{filename=" + this.filename + "}";
    }

    public int hashCode() {
        return Objects.hash(this.filename, this.query);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchDownload that = (BatchDownload)o;
        return Objects.equals(this.filename, that.filename) && Objects.equals(this.query, that.query);
    }
}

