/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.function;

import java.util.Objects;
import java.util.function.Function;

@FunctionalInterface
public interface TerFunction<A, B, C, R> {
    public R apply(A var1, B var2, C var3);

    default public <S> TerFunction<A, B, C, S> andThen(Function<? super R, ? extends S> after) {
        Objects.requireNonNull(after);
        return (a, b, c) -> after.apply((R)this.apply(a, b, c));
    }

    default public <T> TerFunction<T, B, C, R> compose(Function<? super T, ? extends A> before) {
        Objects.requireNonNull(before);
        return (t, b, c) -> this.apply(before.apply(t), b, c);
    }

    public static <A, B, C, R> Function<A, Function<B, Function<C, R>>> curry(TerFunction<A, B, C, R> f) {
        return a -> b -> c -> f.apply(a, b, c);
    }

    public static <A, B, C, R> TerFunction<A, B, C, R> uncurry(Function<A, Function<B, Function<C, R>>> f) {
        return (a, b, c) -> ((Function)((Function)f.apply(a)).apply(b)).apply(c);
    }
}

