/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.io;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.transfer.MultipleFileUpload;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.amazonaws.services.s3.transfer.Upload;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public class RemoteFiles {
    private static final String S3_DATASHARE_BUCKET_NAME = "datashare-nlp";
    private static final String S3_DATASHARE_ENDPOINT = "s3-accelerate.amazonaws.com/";
    private static final String S3_REGION = "us-east-1";
    private static final int READ_TIMEOUT_MS = 120000;
    private static final int CONNECTION_TIMEOUT_MS = 30000;
    private final AmazonS3 s3Client;
    private final String bucket;

    RemoteFiles(AmazonS3 s3Client, String bucket) {
        this.s3Client = s3Client;
        this.bucket = bucket;
    }

    public static RemoteFiles getDefault() {
        ClientConfiguration config = new ClientConfiguration();
        config.setConnectionTimeout(30000);
        config.setSocketTimeout(120000);
        return new RemoteFiles((AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(S3_DATASHARE_ENDPOINT, S3_REGION))).withClientConfiguration(config)).build(), S3_DATASHARE_BUCKET_NAME);
    }

    public static RemoteFiles getAuthenticated() {
        ClientConfiguration config = new ClientConfiguration();
        config.setConnectionTimeout(30000);
        config.setSocketTimeout(120000);
        return new RemoteFiles((AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(S3_DATASHARE_ENDPOINT, S3_REGION))).withCredentials((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance())).withClientConfiguration(config)).build(), S3_DATASHARE_BUCKET_NAME);
    }

    public void upload(File localFile, String remoteKey) throws InterruptedException, FileNotFoundException {
        if (localFile.isDirectory()) {
            TransferManager transferManager = TransferManagerBuilder.standard().withS3Client(this.s3Client).build();
            MultipleFileUpload uploads = transferManager.uploadDirectory(this.bucket, remoteKey, localFile, true);
            for (Upload upload : uploads.getSubTransfers()) {
                upload.waitForUploadResult();
            }
            transferManager.shutdownNow(false);
        } else {
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength(localFile.length());
            this.s3Client.putObject(new PutObjectRequest(this.bucket, remoteKey, (InputStream)new FileInputStream(localFile), metadata));
        }
    }

    public void download(String remoteKey, File localFile) throws InterruptedException, IOException {
        if (localFile.isDirectory()) {
            TransferManager transferManager = TransferManagerBuilder.standard().withS3Client(this.s3Client).build();
            transferManager.downloadDirectory(this.bucket, remoteKey, localFile).waitForCompletion();
            transferManager.shutdownNow(false);
        } else {
            S3Object s3Object = this.s3Client.getObject(this.bucket, remoteKey);
            Files.copy((InputStream)s3Object.getObjectContent(), Paths.get(localFile.getPath(), new String[0]), new CopyOption[0]);
        }
    }

    public boolean isSync(String remoteKey, File localFile) throws IOException {
        if (localFile.isDirectory()) {
            File localDir = localFile.toPath().resolve(remoteKey).toFile();
            if (!localDir.isDirectory()) {
                return false;
            }
            ObjectListing remoteS3Objects = this.s3Client.listObjects(this.bucket, remoteKey);
            Map<String, Long> remoteObjectsMap = remoteS3Objects.getObjectSummaries().stream().filter(os -> os.getSize() != 0L).collect(Collectors.toMap(S3ObjectSummary::getKey, S3ObjectSummary::getSize));
            Map<String, Long> localFilesMap = Files.walk(localDir.toPath(), FileVisitOption.FOLLOW_LINKS).map(Path::toFile).filter(File::isFile).collect(Collectors.toMap(f -> this.getKeyFromFile(localFile, (File)f), File::length));
            boolean equals = localFilesMap.equals(remoteObjectsMap);
            if (remoteObjectsMap.isEmpty()) {
                LoggerFactory.getLogger(this.getClass()).warn("remote object map is empty ({})", (Object)remoteKey);
            } else {
                LoggerFactory.getLogger(this.getClass()).debug("remote {} local {} is equal ? {}", new Object[]{remoteObjectsMap, localFilesMap, equals});
            }
            return equals;
        }
        ObjectMetadata objectMetadata = this.s3Client.getObjectMetadata(this.bucket, remoteKey);
        return objectMetadata.getContentLength() == localFile.length();
    }

    private String getKeyFromFile(File localFile, File f) {
        return f.getPath().replace(localFile.getPath(), "").replaceAll("^" + Pattern.quote(File.separator) + "+", "").replace(File.separator, "/");
    }

    boolean objectExists(String key) {
        return this.s3Client.doesObjectExist(this.bucket, key);
    }

    public void shutdown() {
        this.s3Client.shutdown();
    }
}

