/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.text.indexing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import org.icij.datashare.json.JsonObjectMapper;

public class SearchQuery {
    final String query;

    @JsonCreator
    public SearchQuery(@JsonProperty(value="query") String query) {
        this.query = query;
    }

    @JsonIgnore
    public JsonNode asJson() {
        try {
            return JsonObjectMapper.MAPPER.readTree(Optional.ofNullable(this.query).orElseThrow(() -> new IllegalStateException("null query")).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @JsonIgnore
    public boolean isJsonQuery() {
        return !this.isNull() && this.query.trim().startsWith("{") && this.query.trim().endsWith("}");
    }

    @JsonIgnore
    public boolean isNull() {
        return this.query == null;
    }

    public String toString() {
        return this.query;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchQuery that = (SearchQuery)o;
        return Objects.equals(this.query, that.query);
    }

    public int hashCode() {
        return Objects.hash(this.query);
    }
}

