/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.text.nlp;

import java.util.Locale;
import java.util.regex.Pattern;

public interface DocumentMetadataConstants {
    public static final String DEFAULT_VALUE_UNKNOWN = "unknown";
    public static final String DEFAULT_METADATA_FIELD_PREFIX = "tika_metadata_";
    public static final Pattern fieldName = Pattern.compile("[^A-Za-z0-9_]");
    public static final String NAMESPACE_URI_DC = "http://purl.org/dc/elements/1.1/";
    public static final String NAMESPACE_URI_DC_TERMS = "http://purl.org/dc/terms/";
    public static final String PREFIX_DC = "dc";
    public static final String PREFIX_DC_TERMS = "dcterms";
    public static final String FORMAT = "dc:format";
    public static final String IDENTIFIER = "dc:identifier";
    public static final String MODIFIED = "dcterms:modified";
    public static final String CONTRIBUTOR = "dc:contributor";
    public static final String COVERAGE = "dc:coverage";
    public static final String CREATOR = "dc:creator";
    public static final String CREATED = "dcterms:created";
    public static final String DATE = "dc:date";
    public static final String DESCRIPTION = "dc:description";
    public static final String LANGUAGE = "dc:language";
    public static final String PUBLISHER = "dc:publisher";
    public static final String RELATION = "dc:relation";
    public static final String RIGHTS = "dc:rights";
    public static final String SOURCE = "dc:source";
    public static final String SUBJECT = "dc:subject";
    public static final String TITLE = "dc:title";
    public static final String TYPE = "dc:type";
    public static final String RESOURCE_NAME_KEY = "resourceName";

    default public String getField(String key) {
        String normalizedName = fieldName.matcher(key).replaceAll("_").toLowerCase(Locale.ROOT);
        return DEFAULT_METADATA_FIELD_PREFIX + normalizedName;
    }
}

