/*
 * Decompiled with CFR 0.152.
 */
package org.icij.datashare.cli;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.icij.datashare.cli.CliExtensionService;
import org.icij.datashare.cli.DatashareCliOptions;
import org.icij.datashare.cli.Mode;
import org.icij.datashare.cli.spi.CliExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatashareCli {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatashareCli.class);
    public Properties properties;

    public DatashareCli parseArguments(String[] args) {
        OptionSet options;
        OptionParser parser = this.createParser();
        OptionSpec<Void> helpOpt = DatashareCliOptions.help(parser);
        OptionSpec<Void> versionOpt = DatashareCliOptions.version(parser);
        List<CliExtension> extensions = CliExtensionService.getInstance().getExtensions();
        OptionSpec<String> extOption = DatashareCliOptions.extOption(parser);
        if (extensions.size() > 1) {
            System.out.println("For now we only allow one CLI extension");
            System.exit(2);
        } else if (extensions.size() == 1) {
            extensions.get(0).addOptions(parser);
            options = parser.parse(args);
            if (options.has(extOption)) {
                OptionSet extOptions;
                String extId = (String)options.valueOf(extOption);
                if (!extId.equals(extensions.get(0).identifier())) {
                    System.out.println("Unknown extension: " + extId);
                    System.exit(3);
                }
                if ((extOptions = parser.parse(args)).has(helpOpt)) {
                    OptionParser extParser = DatashareCli.createExtParser(extensions.get(0));
                    this.printHelp(extParser);
                    System.exit(0);
                }
                this.properties = this.asProperties(extOptions, null);
                return this;
            }
        }
        try {
            options = parser.parse(args);
            if (options.has(helpOpt)) {
                this.printHelp(parser);
                System.exit(0);
            }
            if (options.has(versionOpt)) {
                System.out.println(this.getVersion());
                System.exit(0);
            }
            this.properties = this.asProperties(options, null);
            if (!Boolean.parseBoolean(this.properties.getProperty("noDigestProject")) && this.properties.getProperty("digestProjectName") == null) {
                this.properties.setProperty("digestProjectName", this.properties.getProperty("defaultProject"));
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse arguments.", (Throwable)e);
            this.printHelp(parser);
            System.exit(1);
        }
        return this;
    }

    private static OptionParser createExtParser(CliExtension cliExtension) {
        OptionParser parser = new OptionParser();
        DatashareCliOptions.extOption(parser);
        DatashareCliOptions.mode(parser);
        cliExtension.addOptions(parser);
        return parser;
    }

    OptionParser createParser() {
        OptionParser parser = new OptionParser();
        DatashareCliOptions.settings(parser);
        DatashareCliOptions.pluginsDir(parser);
        DatashareCliOptions.pluginList(parser);
        DatashareCliOptions.pluginInstall(parser);
        DatashareCliOptions.pluginDelete(parser);
        DatashareCliOptions.extensionsDir(parser);
        DatashareCliOptions.extensionList(parser);
        DatashareCliOptions.extensionInstall(parser);
        DatashareCliOptions.extensionDelete(parser);
        DatashareCliOptions.tcpListenPort(parser);
        DatashareCliOptions.mode(parser);
        DatashareCliOptions.stages(parser);
        DatashareCliOptions.dataDir(parser);
        DatashareCliOptions.enableOcr(parser);
        DatashareCliOptions.language(parser);
        DatashareCliOptions.ocrLanguage(parser);
        DatashareCliOptions.nlpPipelines(parser);
        DatashareCliOptions.resume(parser);
        DatashareCliOptions.scrollSize(parser);
        DatashareCliOptions.scrollSlices(parser);
        DatashareCliOptions.redisPoolSize(parser);
        DatashareCliOptions.elasticsearchDataPath(parser);
        DatashareCliOptions.reportName(parser);
        DatashareCliOptions.parallelism(parser);
        DatashareCliOptions.fileParserParallelism(parser);
        DatashareCliOptions.nlpParallelism(parser);
        DatashareCliOptions.followSymlinks(parser);
        DatashareCliOptions.enableBrowserOpenLink(parser);
        DatashareCliOptions.embeddedDocumentDownloadMaxSize(parser);
        DatashareCliOptions.batchSearchMaxTime(parser);
        DatashareCliOptions.batchThrottle(parser);
        DatashareCliOptions.batchQueueType(parser);
        DatashareCliOptions.sessionStoreType(parser);
        DatashareCliOptions.batchDownloadTimeToLive(parser);
        DatashareCliOptions.batchDownloadMaxNbFiles(parser);
        DatashareCliOptions.batchDownloadMaxSize(parser);
        DatashareCliOptions.batchDownloadEncrypt(parser);
        DatashareCliOptions.batchDownloadDir(parser);
        DatashareCliOptions.smtpUrl(parser);
        DatashareCliOptions.maxContentLength(parser);
        DatashareCliOptions.clusterName(parser);
        DatashareCliOptions.createIndex(parser);
        DatashareCliOptions.defaultUser(parser);
        DatashareCliOptions.defaultProject(parser);
        DatashareCliOptions.esHost(parser);
        DatashareCliOptions.queueName(parser);
        DatashareCliOptions.cors(parser);
        DatashareCliOptions.queueType(parser);
        DatashareCliOptions.busType(parser);
        DatashareCliOptions.messageBusAddress(parser);
        DatashareCliOptions.redisAddress(parser);
        DatashareCliOptions.dataSourceUrl(parser);
        DatashareCliOptions.rootHost(parser);
        DatashareCliOptions.genApiKey(parser);
        DatashareCliOptions.delApiKey(parser);
        DatashareCliOptions.getApiKey(parser);
        DatashareCliOptions.sessionTtlSeconds(parser);
        DatashareCliOptions.protectedUriPrefix(parser);
        DatashareCliOptions.authUsersProvider(parser);
        DatashareCliOptions.oauthSecret(parser);
        DatashareCliOptions.oauthClient(parser);
        DatashareCliOptions.oauthApiUrl(parser);
        DatashareCliOptions.oauthAuthorizeUrl(parser);
        DatashareCliOptions.oauthTokenUrl(parser);
        DatashareCliOptions.authFilter(parser);
        DatashareCliOptions.oauthCallbackPath(parser);
        DatashareCliOptions.digestMethod(parser);
        DatashareCliOptions.digestProjectName(parser);
        DatashareCliOptions.noDigestProject(parser);
        return parser;
    }

    Properties asProperties(OptionSet options, String prefix) {
        Properties properties = new Properties();
        for (Map.Entry entry : options.asMap().entrySet()) {
            OptionSpec spec = (OptionSpec)entry.getKey();
            if (!options.has(spec) && ((List)entry.getValue()).isEmpty()) continue;
            properties.setProperty(this.asPropertyKey(prefix, spec), this.asPropertyValue((List)entry.getValue()));
        }
        return properties;
    }

    private String asPropertyKey(String prefix, OptionSpec<?> spec) {
        List flags = spec.options();
        for (String flag : flags) {
            if (1 >= flag.length()) continue;
            return null == prefix ? flag : prefix + "." + flag;
        }
        throw new IllegalArgumentException("No usable non-short flag: " + flags);
    }

    private String asPropertyValue(List<?> values) {
        String stringValue = values.size() > 0 ? String.valueOf(values.get(values.size() - 1)) : "";
        return stringValue.isEmpty() ? "true" : stringValue;
    }

    private void printHelp(OptionParser parser) {
        try {
            System.out.println("Usage: ");
            parser.printHelpOn((OutputStream)System.out);
        }
        catch (IOException e) {
            LOGGER.debug("Failed to print help message", (Throwable)e);
        }
    }

    public String getVersion() throws IOException {
        Properties versions = new Properties();
        InputStream gitProperties = this.getClass().getResourceAsStream("/git.properties");
        if (gitProperties != null) {
            versions.load(gitProperties);
        }
        return versions.getProperty("git.build.version");
    }

    public Mode mode() {
        return Mode.valueOf(Optional.ofNullable(this.properties).orElse(new Properties()).getProperty("mode"));
    }

    public boolean isWebServer() {
        return Mode.valueOf(Optional.ofNullable(this.properties).orElse(new Properties()).getProperty("mode")).isWebServer();
    }

    public static enum Stage {
        SCAN,
        SCANIDX,
        DEDUPLICATE,
        INDEX,
        NLP;

        public static final Comparator<Stage> comparator;

        public static Optional<Stage> parse(String stage) {
            if (stage == null || stage.isEmpty()) {
                return Optional.empty();
            }
            try {
                return Optional.of(Stage.valueOf(stage.toUpperCase(Locale.ROOT)));
            }
            catch (IllegalArgumentException e) {
                return Optional.empty();
            }
        }

        static {
            comparator = Comparator.comparing(Enum::ordinal);
        }
    }
}

