/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.document;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import org.apache.tika.metadata.Metadata;
import org.icij.extract.document.DigestIdentifier;
import org.icij.extract.document.Identifier;
import org.icij.extract.document.PathDigestIdentifier;
import org.icij.extract.document.PathIdentifier;
import org.icij.extract.document.TikaDocument;
import org.icij.task.Options;
import org.icij.task.annotation.Option;

@org.icij.task.annotation.Options(value={@Option(name="idMethod", description="The method for determining document IDs, for queues that use them. Defaults to using the path as an ID.", parameter="name"), @Option(name="idDigestMethod", description="For calculating document ID digests, where applicable depending on the ID method.", parameter="name"), @Option(name="charset", description="Set the output encoding for text and document attributes. Defaults to UTF-8.", parameter="name"), @Option(name="language", description="Optional parameter to specify the language of the document.", parameter="name")})
public class DocumentFactory {
    private Identifier identifier = null;
    private Charset charset = StandardCharsets.UTF_8;
    private String language = null;

    public DocumentFactory(Options<String> options) {
        this.configure(options);
    }

    public DocumentFactory() {
    }

    public DocumentFactory configure(Options<String> options) {
        this.charset = Charset.forName(options.valueIfPresent("charset").orElse(this.charset.toString()));
        this.language = options.valueIfPresent("language").orElse(null);
        String algorithm = options.valueIfPresent("idDigestMethod").orElse("SHA-256");
        Optional<String> method = options.valueIfPresent("idMethod");
        if (method.isPresent()) {
            return this.withIdentifier(MethodName.valueOf(method.get().toUpperCase()), algorithm);
        }
        this.identifier = new DigestIdentifier(algorithm, this.charset);
        return this;
    }

    public DocumentFactory configure() {
        return this.configure(Options.from(new HashMap<String, String>()));
    }

    public DocumentFactory withIdentifier(MethodName name, String algorithm) {
        switch (name) {
            case PATH: {
                this.identifier = new PathIdentifier();
                break;
            }
            case PATH_DIGEST: {
                this.identifier = new PathDigestIdentifier(algorithm, this.charset);
                break;
            }
            case TIKA_DIGEST: {
                this.identifier = new DigestIdentifier(algorithm, this.charset);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("\"%s\" is not a valid identifier.", new Object[]{name}));
            }
        }
        return this;
    }

    public DocumentFactory withIdentifier(Identifier identifier) {
        Objects.requireNonNull(identifier, "Identifier generator must not be null.");
        this.identifier = identifier;
        return this;
    }

    public TikaDocument create(String id, Path path) {
        return new TikaDocument(id, this.identifier, path, this.language);
    }

    public TikaDocument create(String id, Path path, long size) {
        Metadata metadata = new Metadata();
        metadata.set("Content-Length", Long.toString(size));
        return new TikaDocument(id, this.identifier, path, this.language, metadata);
    }

    public TikaDocument create(String id, Path path, Metadata metadata) {
        return new TikaDocument(id, this.identifier, path, this.language, metadata);
    }

    public TikaDocument create(Path path) {
        return new TikaDocument(this.identifier, path, this.language);
    }

    public TikaDocument create(Path path, BasicFileAttributes attributes) {
        return this.create(path, attributes.size());
    }

    public TikaDocument create(Path path, long size) {
        Metadata metadata = new Metadata();
        metadata.set("Content-Length", Long.toString(size));
        return new TikaDocument(this.identifier, path, this.language, metadata);
    }

    public TikaDocument create(String path) {
        return this.create(Paths.get(path, new String[0]));
    }

    public TikaDocument create(String id, String path) {
        return this.create(id, Paths.get(path, new String[0]));
    }

    public TikaDocument create(Path path, Metadata metadata) {
        return new TikaDocument(this.identifier, path, this.language, metadata);
    }

    public TikaDocument create(URL url) throws URISyntaxException {
        return this.create(Paths.get(url.toURI()));
    }

    public static enum MethodName {
        PATH,
        PATH_DIGEST,
        TIKA_DIGEST;

    }
}

