/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.queue;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.concurrent.BlockingQueue;

public interface DocumentQueue
extends BlockingQueue<Path>,
AutoCloseable {
    public String getName();

    default public boolean remove(Object o, int count) {
        boolean removed = false;
        if (count == 0) {
            boolean hasMaybeMore = true;
            while (hasMaybeMore) {
                hasMaybeMore = this.remove(o);
                removed |= hasMaybeMore;
            }
        } else {
            for (int i = 0; i < count; ++i) {
                removed |= this.remove(o);
            }
        }
        return removed;
    }

    default public int removeDuplicates() {
        HashMap documents = new HashMap();
        int initialSize = this.size();
        this.forEach(path -> documents.compute(path, (k, v) -> v == null ? 1 : v + 1));
        documents.entrySet().stream().filter(e -> (Integer)e.getValue() > 1).forEach(e -> this.remove(e.getKey(), (Integer)e.getValue() - 1));
        return initialSize - this.size();
    }
}

