/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.redis;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.icij.extract.queue.DocumentSet;
import org.icij.extract.redis.RedisDocumentQueue;
import org.icij.extract.redis.RedissonClientFactory;
import org.icij.task.Options;
import org.redisson.Redisson;
import org.redisson.RedissonSet;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandSyncService;
import org.redisson.liveobject.core.RedissonObjectBuilder;

public class RedisDocumentSet
extends RedissonSet<Path>
implements DocumentSet {
    public static String DEFAULT_NAME = "extract:filter";
    private final RedissonClient redissonClient;

    public RedisDocumentSet(final String setName, final String redisAddress) {
        this(Options.from((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("redisAddress", redisAddress);
                this.put("setName", setName);
            }
        }));
    }

    public RedisDocumentSet(Options<String> options) {
        this(new RedissonClientFactory().withOptions(options).create(), options.valueIfPresent("setName").orElse(DEFAULT_NAME), Charset.forName(options.valueIfPresent("charset").orElse("UTF-8")));
    }

    private RedisDocumentSet(RedissonClient redissonClient, String name, Charset charset) {
        super((Codec)new RedisDocumentQueue.PathQueueCodec(charset), (CommandAsyncExecutor)new CommandSyncService(((Redisson)redissonClient).getConnectionManager(), new RedissonObjectBuilder(redissonClient)), null == name ? DEFAULT_NAME : name, redissonClient);
        this.redissonClient = redissonClient;
    }

    public String toString() {
        return "RedisDocumentSet{name=" + this.getName() + "}";
    }

    @Override
    public void close() {
        this.redissonClient.shutdown();
    }
}

