/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.redis;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.icij.extract.report.Report;
import org.redisson.client.protocol.Encoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultEncoder
implements Encoder {
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public ByteBuf encode(Object in) throws IOException {
        Report report = (Report)in;
        ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
        out.writeBytes(String.valueOf(report.getStatus().getCode()).getBytes());
        ByteBuf exceptionPayload = ByteBufAllocator.DEFAULT.buffer();
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)new ByteBufOutputStream(exceptionPayload));){
            report.getException().ifPresent(e -> {
                out.writeBytes("|".getBytes());
                try {
                    objectOutputStream.writeObject(e);
                    out.writeBytes(exceptionPayload);
                }
                catch (IOException ex) {
                    this.logger.error("exception when serializing exception :", (Throwable)e);
                }
            });
        }
        return out;
    }
}

