/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.extractor;

import java.util.HashMap;
import java.util.Map;

public enum ExtractionStatus {
    SUCCESS(0),
    FAILURE_NOT_FOUND(1),
    FAILURE_UNREADABLE(2),
    FAILURE_NOT_DECRYPTED(3),
    FAILURE_NOT_PARSED(4),
    FAILURE_UNKNOWN(8),
    FAILURE_NOT_SAVED(9);

    private final int code;
    private static final Map<Integer, ExtractionStatus> lookup;

    public static ExtractionStatus parse(Number value) {
        return ExtractionStatus.parse(value.intValue());
    }

    public static ExtractionStatus parse(Integer value) {
        return lookup.get(value);
    }

    public static ExtractionStatus parse(String value) {
        try {
            return ExtractionStatus.parse(Integer.valueOf(value));
        }
        catch (NumberFormatException e) {
            return ExtractionStatus.valueOf(value);
        }
    }

    private ExtractionStatus(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    static {
        lookup = new HashMap<Integer, ExtractionStatus>();
        for (ExtractionStatus result : ExtractionStatus.values()) {
            lookup.put(result.getCode(), result);
        }
    }
}

