/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.ContentHandlerDecorator;
import org.apache.tika.sax.ExpandedTitleContentHandler;
import org.icij.extract.document.EmbeddedTikaDocument;
import org.icij.extract.document.TikaDocument;
import org.icij.extract.io.DataURIEncodingInputStream;
import org.icij.extract.io.TokenReplacingReader;
import org.icij.extract.parser.HTML5Serializer;
import org.icij.extract.parser.ParsingReader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class EmbeddingHTMLParsingReader
extends ParsingReader {
    private final TokenReplacingReader replacer;

    public EmbeddingHTMLParsingReader(TikaDocument parent, String open, String close, Parser parser, TikaInputStream input, Metadata metadata, ParseContext context) throws IOException {
        super(parser, (InputStream)input, metadata, context, writer -> new SubstitutingContentHandler(parent, open, close, (ContentHandler)new ExpandedTitleContentHandler((ContentHandler)new HTML5Serializer((Writer)writer))));
        this.replacer = new TokenReplacingReader(token -> {
            EmbeddedTikaDocument embed = parent.getEmbed(token);
            if (null == embed) {
                return null;
            }
            return DataURIEncodingInputStream.createReader(embed.getPath(), embed.getMetadata());
        }, this.reader, open, close);
    }

    @Override
    public int read(char[] buffer, int offset, int length) throws IOException {
        return this.replacer.read(buffer, offset, length);
    }

    @Override
    public void close() throws IOException {
        this.replacer.close();
        super.close();
    }

    private static class SubstitutingContentHandler
    extends ContentHandlerDecorator {
        private boolean isEmbeddedImgTagOpen = false;
        private boolean isEmbeddedAnchorTagOpen = false;
        private boolean anchorTagDropped = false;
        private AttributesImpl imgAttributes = null;
        private static final String IMG_TAG = "img";
        private static final String ANCHOR_TAG = "a";
        private final TikaDocument parent;
        private final String open;
        private final String close;

        SubstitutingContentHandler(TikaDocument parent, String open, String close, ContentHandler handler) {
            super(handler);
            this.open = open;
            this.close = close;
            this.parent = parent;
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            AttributesImpl attributes = new AttributesImpl(atts);
            if (IMG_TAG.equalsIgnoreCase(localName) && "http://www.w3.org/1999/xhtml".equals(uri) && !this.isEmbeddedImgTagOpen && !this.isEmbeddedAnchorTagOpen) {
                String src = attributes.getValue("", "src");
                if (null != src && src.startsWith("embedded:")) {
                    this.isEmbeddedImgTagOpen = true;
                    this.imgAttributes = attributes;
                } else if (null != src && src.startsWith("cid:")) {
                    super.startElement(uri, localName, qName, atts);
                }
            } else if (ANCHOR_TAG.equalsIgnoreCase(localName) && "http://www.w3.org/1999/xhtml".equals(uri) && !this.isEmbeddedAnchorTagOpen) {
                String href = attributes.getValue("", "href");
                String path = null;
                if (null != href && href.startsWith(this.open) && href.endsWith(this.close)) {
                    path = href.substring(this.open.length(), href.length() - this.close.length());
                }
                if (null != path && null != this.parent.getEmbed(path)) {
                    this.isEmbeddedAnchorTagOpen = true;
                    if (this.isEmbeddedImgTagOpen) {
                        this.imgAttributes.setAttribute(this.imgAttributes.getIndex("", "src"), "", "src", "src", "CDATA", href);
                        super.startElement(uri, IMG_TAG, IMG_TAG, (Attributes)this.imgAttributes);
                        super.endElement(uri, IMG_TAG, IMG_TAG);
                        this.isEmbeddedImgTagOpen = false;
                        this.imgAttributes = null;
                        this.anchorTagDropped = true;
                    } else {
                        super.startElement(uri, localName, qName, (Attributes)attributes);
                        this.anchorTagDropped = false;
                    }
                } else if (this.isEmbeddedImgTagOpen) {
                    this.isEmbeddedImgTagOpen = false;
                    this.imgAttributes = null;
                    super.startElement(uri, localName, qName, (Attributes)attributes);
                }
            } else {
                if (this.isEmbeddedAnchorTagOpen) {
                    this.isEmbeddedAnchorTagOpen = false;
                    this.anchorTagDropped = false;
                }
                if (this.isEmbeddedImgTagOpen) {
                    this.isEmbeddedImgTagOpen = false;
                    this.imgAttributes = null;
                }
                super.startElement(uri, localName, qName, (Attributes)attributes);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (!this.isEmbeddedAnchorTagOpen || !this.anchorTagDropped) {
                super.characters(ch, start, length);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.isEmbeddedImgTagOpen && IMG_TAG.equalsIgnoreCase(localName) && "http://www.w3.org/1999/xhtml".equals(uri)) {
                return;
            }
            if (this.isEmbeddedImgTagOpen) {
                super.startElement(uri, IMG_TAG, IMG_TAG, (Attributes)this.imgAttributes);
                this.isEmbeddedImgTagOpen = false;
                this.imgAttributes = null;
            }
            if (this.isEmbeddedAnchorTagOpen && ANCHOR_TAG.equalsIgnoreCase(localName) && "http://www.w3.org/1999/xhtml".equals(uri)) {
                this.isEmbeddedAnchorTagOpen = false;
            } else {
                super.endElement(uri, localName, qName);
            }
        }
    }
}

