/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;

public class ParsingReader
extends Reader {
    private final Executor executor = new ParsingExecutor();
    protected final Parser parser;
    protected final Reader reader;
    private final Writer writer;
    protected final InputStream input;
    protected final Metadata metadata;
    protected final ParseContext context;
    protected final ContentHandler handler;
    private transient Throwable throwable;

    private static Metadata getMetadata(String name) {
        Metadata metadata = new Metadata();
        if (name != null && name.length() > 0) {
            metadata.set("resourceName", name);
        }
        return metadata;
    }

    public ParsingReader(InputStream input) throws IOException {
        this((Parser)new AutoDetectParser(), input, ParsingReader.getMetadata(null), new ParseContext());
        this.context.set(Parser.class, (Object)this.parser);
    }

    public ParsingReader(InputStream input, String name) throws IOException {
        this((Parser)new AutoDetectParser(), input, ParsingReader.getMetadata(name), new ParseContext());
        this.context.set(Parser.class, (Object)this.parser);
    }

    public ParsingReader(Parser parser, InputStream input, Metadata metadata, ParseContext context) throws IOException {
        this(parser, input, metadata, context, BodyContentHandler::new);
    }

    public ParsingReader(Parser parser, InputStream input, Metadata metadata, ParseContext context, Function<Writer, ContentHandler> handler) throws IOException {
        PipedReader pipedReader = new PipedReader();
        this.parser = parser;
        this.reader = new BufferedReader(pipedReader);
        try {
            this.writer = new PipedWriter(pipedReader);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.input = input;
        this.metadata = metadata;
        this.context = context;
        this.handler = handler.apply(this.writer);
        this.parse();
        this.reader.mark(1);
        this.reader.read();
        this.reader.reset();
    }

    @Override
    public int read(char[] buffer, int off, int len) throws IOException {
        if (this.throwable instanceof IOException) {
            throw (IOException)this.throwable;
        }
        if (this.throwable != null) {
            throw new IOException("", this.throwable);
        }
        return this.reader.read(buffer, off, len);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public void parse() {
        this.executor.execute(() -> {
            block7: {
                block6: {
                    try {
                        this.parser.parse(this.input, this.handler, this.metadata, this.context);
                    }
                    catch (Throwable t) {
                        this.throwable = t;
                    }
                    try {
                        this.input.close();
                    }
                    catch (Throwable t) {
                        if (this.throwable != null) break block6;
                        this.throwable = t;
                    }
                }
                try {
                    this.writer.close();
                }
                catch (Throwable t) {
                    if (this.throwable != null) break block7;
                    this.throwable = t;
                }
            }
        });
    }

    private class ParsingExecutor
    implements Executor {
        private ParsingExecutor() {
        }

        @Override
        public void execute(Runnable task) {
            Object name = ParsingReader.this.metadata.get("resourceName");
            name = name != null ? "ICIJ Extract: " + (String)name : "ICIJ Extract";
            Thread thread = new Thread(task, (String)name);
            thread.setDaemon(true);
            thread.start();
        }
    }
}

