/*
 * Decompiled with CFR 0.152.
 */
package org.icij.spewer;

import java.util.Locale;
import java.util.regex.Pattern;
import org.icij.task.Options;
import org.icij.task.annotation.Option;

@org.icij.task.annotation.Options(value={@Option(name="idField", description="Index field for an automatically generated identifier. The ID for the same file is guaranteed not to change if the path doesn't change. Defaults to \"id\".", code="i", parameter="name"), @Option(name="textField", description="Field name for extracted text.", code="t", parameter="name"), @Option(name="pathField", description="Field name for the file path.", parameter="name", code="p"), @Option(name="parentPathField", description="Field name for the parent directory path.", parameter="name"), @Option(name="parentField", description="Field name for the parent ID on child documents.", parameter="name"), @Option(name="levelField", description="Field name for the hierarchy level field.", parameter="name"), @Option(name="baseTypeField", description="Field name for the base content-type.", parameter="name"), @Option(name="versionField", description="Index field name for the version.", parameter="name"), @Option(name="tagPrefix", description="Prefix for tag fields added to the index.", parameter="name"), @Option(name="metadataPrefix", description="Prefix for metadata fields added to the index.", parameter="name"), @Option(name="metadataISODatePostfix", description="Postfix for 'fixed' ISO 8601 metadata fields.", parameter="name")})
public class FieldNames {
    private static final Pattern fieldName = Pattern.compile("[^A-Za-z0-9_]");
    public static final String DEFAULT_ID_FIELD = "extract_id";
    public static final String DEFAULT_TEXT_FIELD = "tika_content";
    public static final String DEFAULT_PATH_FIELD = "extract_paths";
    public static final String DEFAULT_BASE_TYPE_FIELD = "extract_base_type";
    public static final String DEFAULT_PARENT_PATH_FIELD = "extract_parent_paths";
    public static final String DEFAULT_PARENT_ID_FIELD = "extract_parent_id";
    public static final String DEFAULT_ROOT_FIELD = "extract_root";
    public static final String DEFAULT_LEVEL_FIELD = "extract_level";
    public static final String DEFAULT_VERSION_FIELD = "_version_";
    public static final String DEFAULT_METADATA_FIELD_PREFIX = "tika_metadata_";
    public static final String DEFAULT_TAG_FIELD_PREFIX = "tag_";
    public static final String DEFAULT_METADATA_ISO_DATE_POSTFIX = "_iso8601";
    private String textField = "tika_content";
    private String pathField = "extract_paths";
    private String parentPathField = "extract_parent_paths";
    private String idField = "extract_id";
    private String baseTypeField = "extract_base_type";
    private String versionField = "_version_";
    private String parentIdField = "extract_parent_id";
    private String rootField = "extract_root";
    private String levelField = "extract_level";
    private String tagFieldPrefix = "tag_";
    private String metadataFieldPrefix = "tika_metadata_";
    private String metadataISODatePostfix = "_iso8601";

    public FieldNames configure(Options<String> options) {
        options.get("textField").value().ifPresent(this::forText);
        options.get("pathField").value().ifPresent(this::forPath);
        options.get("parentPathField").value().ifPresent(this::forParentPath);
        options.get("parentField").value().ifPresent(this::forParentId);
        options.get("levelField").value().ifPresent(this::forLevel);
        options.get("baseTypeField").value().ifPresent(this::forBaseType);
        options.get("versionField").value().ifPresent(this::forVersion);
        options.get("idField").value().ifPresent(this::forId);
        options.get("tagPrefix").value().ifPresent(this::forTagPrefix);
        options.get("metadataPrefix").value().ifPresent(this::forMetadataPrefix);
        options.get("metadataISODatePostfix").value().ifPresent(this::forMetadataISODatePostfix);
        return this;
    }

    private void forText(String textField) {
        this.textField = textField;
    }

    public String forText() {
        return this.textField;
    }

    private void forPath(String pathField) {
        this.pathField = pathField;
    }

    public String forPath() {
        return this.pathField;
    }

    private void forParentPath(String parentPathField) {
        this.parentPathField = parentPathField;
    }

    public String forParentPath() {
        return this.parentPathField;
    }

    private void forParentId(String parentIdField) {
        this.parentIdField = parentIdField;
    }

    public String forParentId() {
        return this.parentIdField;
    }

    private void forRoot(String rootField) {
        this.rootField = rootField;
    }

    public String forRoot() {
        return this.rootField;
    }

    private void forLevel(String levelField) {
        this.levelField = levelField;
    }

    public String forLevel() {
        return this.levelField;
    }

    private void forBaseType(String baseTypeField) {
        this.baseTypeField = baseTypeField;
    }

    public String forBaseType() {
        return this.baseTypeField;
    }

    private void forVersion(String versionField) {
        this.versionField = versionField;
    }

    public String forVersion() {
        return this.versionField;
    }

    private void forId(String idField) {
        this.idField = idField;
    }

    public String forId() {
        return this.idField;
    }

    private void forMetadataPrefix(String metadataFieldPrefix) {
        this.metadataFieldPrefix = metadataFieldPrefix;
    }

    public String forMetadata(String name) {
        String normalizedName = fieldName.matcher(name).replaceAll("_").toLowerCase(Locale.ROOT);
        if (null != this.metadataFieldPrefix) {
            return this.metadataFieldPrefix + normalizedName;
        }
        return normalizedName;
    }

    private void forMetadataISODatePostfix(String metadataISODatePostfix) {
        this.metadataISODatePostfix = metadataISODatePostfix;
    }

    public String forMetadataISODate(String name) {
        return this.forMetadata(name) + this.metadataISODatePostfix;
    }

    private void forTagPrefix(String tagFieldPrefix) {
        this.tagFieldPrefix = tagFieldPrefix;
    }

    public String forTag(String name) {
        return this.tagFieldPrefix + name;
    }
}

