/*
 * Decompiled with CFR 0.152.
 */
package org.icij.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.icij.task.OptionParser;

public class Option<V> {
    private final String name;
    private Character code = null;
    private String description = null;
    private String parameter = null;
    protected Supplier<List<V>> values = new DefaultSupplier();
    protected final Function<Option<V>, OptionParser<V>> parser;

    public Option(String name, Function<Option<V>, OptionParser<V>> parser) {
        this.name = name;
        this.parser = parser;
    }

    public Option<V> code(Character code) {
        this.code = code;
        return this;
    }

    public Option<V> code(String code) {
        if (!code.isEmpty()) {
            this.code = Character.valueOf(code.toCharArray()[0]);
        }
        return this;
    }

    public Option<V> describe(String description) {
        this.description = description;
        return this;
    }

    public String description() {
        return this.description;
    }

    public String name() {
        return this.name;
    }

    public Character code() {
        return this.code;
    }

    public String parameter() {
        return this.parameter;
    }

    public Option<V> parameter(String parameter) {
        this.parameter = parameter;
        return this;
    }

    public synchronized Optional<V> value() {
        List<V> values = this.values.get();
        if (!values.isEmpty()) {
            return Optional.of(values.get(0));
        }
        return Optional.empty();
    }

    public synchronized List<V> values() {
        return this.values.get();
    }

    public synchronized Option<V> update(V value) {
        List<V> values = this.values.get();
        values.clear();
        values.add(value);
        return this;
    }

    public synchronized Option<V> update(List<V> values) {
        this.values.get().clear();
        this.values.get().addAll(values);
        return this;
    }

    public synchronized Option<V> update(Supplier<List<V>> supplier) {
        this.values = supplier;
        return this;
    }

    public synchronized <R> Optional<R> value(Function<V, R> parser) {
        List<V> values = this.values.get();
        if (values.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(parser.apply(values.get(0)));
    }

    public synchronized <R> Collection<R> values(Function<V, R> parser) {
        List<V> values = this.values.get();
        ArrayList<R> results = new ArrayList<R>(values.size());
        for (V value : values) {
            results.add(parser.apply(value));
        }
        return results;
    }

    public OptionParser<V> parse() {
        return this.parser.apply(this);
    }

    public String toString() {
        return this.name + "=" + String.join((CharSequence)",", this.values.get().stream().map(Object::toString).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Option option = (Option)o;
        return Objects.equals(this.name, option.name) && Objects.equals(this.values.get(), option.values.get());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.values.get());
    }

    private static class DefaultSupplier<V>
    implements Supplier<List<V>> {
        private final List<V> values = new LinkedList<V>();

        private DefaultSupplier() {
        }

        @Override
        public List<V> get() {
            return this.values;
        }
    }
}

