/*
 * Decompiled with CFR 0.152.
 */
package org.icij.task;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.icij.task.Option;
import org.icij.task.OptionParser;
import org.icij.task.OptionsIterator;
import org.icij.task.StringOptionParser;
import org.icij.task.annotation.OptionsClass;

public class Options<T>
implements Iterable<Option<T>> {
    protected final Map<String, Option<T>> map = new HashMap<String, Option<T>>();

    public <R> Optional<R> ifPresent(String name, Function<Option<T>, Optional<R>> function) {
        return this.map.containsKey(name) ? function.apply(this.get(name)) : Optional.empty();
    }

    public Optional<T> valueIfPresent(String name) {
        return this.map.containsKey(name) ? this.map.get(name).value() : Optional.empty();
    }

    public Option<T> get(String name) {
        return this.map.get(name);
    }

    public Option<T> get(Option<T> option) {
        return this.map.get(option.name());
    }

    public Options<T> add(Option<T> option) {
        this.map.put(option.name(), option);
        return this;
    }

    public Option<T> add(String name, Function<Option<T>, OptionParser<T>> parser) {
        Option option = new Option(name, parser);
        this.add(option);
        return option;
    }

    public Option<T> add(org.icij.task.annotation.Option option, Function<Option<T>, OptionParser<T>> parser) {
        return this.add(option.name(), parser).describe(option.description()).parameter(option.parameter()).code(option.code());
    }

    public void add(OptionsClass optionsClass, Function<Option<T>, OptionParser<T>> parser) {
        for (org.icij.task.annotation.Option option : (org.icij.task.annotation.Option[])optionsClass.value().getAnnotationsByType(org.icij.task.annotation.Option.class)) {
            this.add(option, parser);
        }
        for (Annotation annotation : (OptionsClass[])optionsClass.value().getAnnotationsByType(OptionsClass.class)) {
            this.add((OptionsClass)annotation, parser);
        }
    }

    public static Options<String> from(Map<String, String> stringProperties) {
        Options<String> options = new Options<String>();
        stringProperties.forEach((? super K key, ? super V value) -> options.add(new Option<String>((String)key, StringOptionParser::new).update((String)value)));
        return options;
    }

    public static Options<String> from(Properties stringProperties) {
        HashMap<String, String> map = new HashMap<String, String>();
        stringProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> map.put((String)key, (String)value)));
        return Options.from(map);
    }

    @Override
    public Iterator<Option<T>> iterator() {
        return new OptionsIterator<T>(this.map);
    }

    public String toString() {
        return "{" + String.join((CharSequence)",", this.map.values().stream().map(Object::toString).collect(Collectors.toList())) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Options options = (Options)o;
        return Objects.equals(this.map, options.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }

    public Options<T> createFrom(Options<T> optionsToBind) {
        Options options = new Options();
        this.map.forEach((? super K k, ? super V v) -> options.add(optionsToBind.ifContains((String)k).orElse((Option<Option>)v)));
        return options;
    }

    private Optional<Option<T>> ifContains(String name) {
        return this.map.containsKey(name) ? Optional.of(this.map.get(name)) : Optional.empty();
    }
}

