/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.cleaner;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.icij.extract.cleaner.CleanContext;
import org.icij.extract.cleaner.Cleaner;
import org.icij.extract.cleaner.DocumentSource;

public class ContentCleaner
implements Cleaner {
    private final List<Cleaner> cleanerList;
    Detector detector = new DefaultDetector();

    public ContentCleaner(List<Cleaner> cleanerList) {
        this.cleanerList = cleanerList;
    }

    @Override
    public Set<MediaType> getSupportedTypes(CleanContext context) {
        HashSet<MediaType> mediaTypes = new HashSet<MediaType>();
        mediaTypes.addAll(MediaType.set((String[])new String[]{"application/pdf"}));
        mediaTypes.addAll(MediaType.set((String[])new String[]{"application/msword"}));
        return mediaTypes;
    }

    @Override
    public void clean(InputStream stream, DocumentSource documentSource, Metadata metadata, CleanContext context) throws IOException {
        try (TikaInputStream tis = TikaInputStream.get((InputStream)new CloseShieldInputStream(stream));){
            MediaType type = this.detector.detect((InputStream)tis, metadata);
            if (this.getSupportedTypes(context).contains(type)) {
                Cleaner cleaner = this.getCleaners(context).get(type);
                cleaner.clean((InputStream)tis, documentSource, metadata, context);
            } else {
                IOUtils.copy((InputStream)tis, (OutputStream)documentSource.getOutputStream());
            }
        }
    }

    public Map<MediaType, Cleaner> getCleaners(CleanContext context) {
        HashMap<MediaType, Cleaner> map = new HashMap<MediaType, Cleaner>();
        for (Cleaner cleaner : this.cleanerList) {
            for (MediaType type : cleaner.getSupportedTypes(context)) {
                map.put(type, cleaner);
            }
        }
        return map;
    }
}

