/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.document;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import javax.xml.bind.DatatypeConverter;
import org.icij.extract.document.AbstractIdentifier;
import org.icij.extract.document.EmbeddedTikaDocument;
import org.icij.extract.document.TikaDocument;

public class PathDigestIdentifier
extends AbstractIdentifier {
    PathDigestIdentifier(String algorithm, Charset charset) {
        super(algorithm, charset);
    }

    @Override
    public String generate(TikaDocument document) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(this.algorithm);
        digest.update(document.getPath().toString().getBytes(this.charset));
        return DatatypeConverter.printHexBinary((byte[])digest.digest()).toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String generateForEmbed(EmbeddedTikaDocument embed) throws NoSuchAlgorithmException {
        return this.generate(embed);
    }
}

