/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.queue;

import java.util.concurrent.ArrayBlockingQueue;
import org.icij.extract.queue.DocumentQueue;
import org.icij.task.Options;
import org.icij.task.annotation.Option;

@org.icij.task.annotation.Options(value={@Option(name="queueName", description="The name of the queue.", parameter="name"), @Option(name="queueBuffer", description="The size of the internal file path buffer used by the queue.", parameter="size")})
public class MemoryDocumentQueue<T>
extends ArrayBlockingQueue<T>
implements DocumentQueue<T> {
    private static final long serialVersionUID = -7491630465350342533L;
    private final String queueName;

    MemoryDocumentQueue(Options<String> options) {
        this(options.get("queueName").value().orElse("extract:queue"), options.get("queueBuffer").parse().asInteger().orElse(1024));
    }

    public MemoryDocumentQueue(String queueName, int capacity) {
        super(capacity);
        this.queueName = queueName;
    }

    @Override
    public boolean delete() {
        this.clear();
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public String getName() {
        return this.queueName;
    }
}

