/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.redis;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.icij.extract.queue.DocumentQueue;
import org.icij.extract.redis.PathDecoder;
import org.icij.extract.redis.PathEncoder;
import org.icij.extract.redis.RedissonClientFactory;
import org.icij.task.Options;
import org.icij.task.annotation.Option;
import org.icij.task.annotation.OptionsClass;
import org.redisson.Redisson;
import org.redisson.RedissonBlockingQueue;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandSyncService;
import org.redisson.liveobject.core.RedissonObjectBuilder;

@org.icij.task.annotation.Options(value={@Option(name="queueName", description="The name of the queue.", parameter="name"), @Option(name="charset", description="Set the output encoding for strings. Defaults to UTF-8.", parameter="name")})
@OptionsClass(value=RedissonClientFactory.class)
public class RedisDocumentQueue<T>
extends RedissonBlockingQueue<T>
implements DocumentQueue<T> {
    private static final String DEFAULT_NAME = "extract:queue";
    private final RedissonClient redissonClient;
    private final boolean shouldShutdownRedisson;

    public RedisDocumentQueue(final String queueName, final String redisAddress, Class<T> clazz) {
        this(Options.from((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("redisAddress", redisAddress);
                this.put("queueName", queueName);
            }
        }), clazz);
    }

    public RedisDocumentQueue(Options<String> options, Class<T> clazz) {
        this(new RedissonClientFactory().withOptions(options).create(), options.valueIfPresent("queueName").orElse(DEFAULT_NAME), Charset.forName(options.valueIfPresent("charset").orElse("UTF-8")), clazz, true);
    }

    protected RedisDocumentQueue(RedissonClient redissonClient, String name, Charset charset, Class<T> clazz) {
        this(redissonClient, name, charset, clazz, false);
    }

    protected RedisDocumentQueue(RedissonClient redissonClient, String name, Charset charset, Class<T> clazz, boolean shouldShutdownRedisson) {
        this((Codec)new QueueCodec<T>(charset, clazz), (CommandAsyncExecutor)new CommandSyncService(((Redisson)redissonClient).getConnectionManager(), new RedissonObjectBuilder(redissonClient)), null == name ? DEFAULT_NAME : name, redissonClient, shouldShutdownRedisson);
    }

    protected RedisDocumentQueue(Codec codec, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson, boolean shouldShutdownRedisson) {
        super(codec, commandExecutor, name, redisson);
        this.redissonClient = redisson;
        this.shouldShutdownRedisson = shouldShutdownRedisson;
    }

    @Override
    public boolean remove(Object o, int count) {
        return super.remove(o, count);
    }

    @Override
    public void close() throws IOException {
        if (this.shouldShutdownRedisson) {
            this.redissonClient.shutdown();
        }
    }

    public String toString() {
        return "RedisDocumentQueue{name=" + this.getName() + "}";
    }

    static class QueueCodec<T>
    extends BaseCodec {
        private final Decoder<Object> decoder;
        private final Encoder documentEncoder;

        QueueCodec(Charset charset, Class<T> clazz) {
            this.decoder = clazz.isAssignableFrom(Path.class) ? new PathDecoder(charset) : (buf, state) -> {
                String str = buf.toString(charset);
                buf.readerIndex(buf.readableBytes());
                return str;
            };
            this.documentEncoder = new PathEncoder(charset);
        }

        public Decoder<Object> getValueDecoder() {
            return this.decoder;
        }

        public Decoder<Object> getMapValueDecoder() {
            return this.decoder;
        }

        public Decoder<Object> getMapKeyDecoder() {
            return this.decoder;
        }

        public Encoder getMapValueEncoder() {
            return this.documentEncoder;
        }

        public Encoder getMapKeyEncoder() {
            return this.documentEncoder;
        }

        public Encoder getValueEncoder() {
            return this.documentEncoder;
        }
    }
}

