/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.redis;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.icij.extract.queue.DocumentSet;
import org.icij.extract.redis.RedisDocumentQueue;
import org.icij.extract.redis.RedissonClientFactory;
import org.icij.task.Options;
import org.redisson.Redisson;
import org.redisson.RedissonSet;
import org.redisson.api.RedissonClient;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandSyncService;
import org.redisson.liveobject.core.RedissonObjectBuilder;

public class RedisDocumentSet<T>
extends RedissonSet<T>
implements DocumentSet<T> {
    public static String DEFAULT_NAME = "extract:filter";
    private final RedissonClient redissonClient;
    private final boolean shouldShutdownRedisson;

    public RedisDocumentSet(final String setName, final String redisAddress, Class<T> clazz) {
        this(Options.from((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("redisAddress", redisAddress);
                this.put("setName", setName);
            }
        }), clazz);
    }

    public RedisDocumentSet(Options<String> options, Class<T> clazz) {
        this(new RedissonClientFactory().withOptions(options).create(), options.valueIfPresent("setName").orElse(DEFAULT_NAME), Charset.forName(options.valueIfPresent("charset").orElse("UTF-8")), clazz, true);
    }

    protected RedisDocumentSet(RedissonClient redissonClient, String name, Charset charset, Class<T> clazz) {
        this(redissonClient, name, charset, clazz, false);
    }

    protected RedisDocumentSet(RedissonClient redissonClient, String name, Charset charset, Class<T> clazz, boolean shouldShutdownRedisson) {
        super(new RedisDocumentQueue.QueueCodec<T>(charset, clazz), (CommandAsyncExecutor)new CommandSyncService(((Redisson)redissonClient).getConnectionManager(), new RedissonObjectBuilder(redissonClient)), null == name ? DEFAULT_NAME : name, redissonClient);
        this.redissonClient = redissonClient;
        this.shouldShutdownRedisson = shouldShutdownRedisson;
    }

    public String toString() {
        return "RedisDocumentSet{name=" + this.getName() + "}";
    }

    @Override
    public void close() {
        if (this.shouldShutdownRedisson) {
            this.redissonClient.shutdown();
        }
    }
}

