/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.redis;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.icij.extract.redis.PathDecoder;
import org.icij.extract.redis.PathEncoder;
import org.icij.extract.redis.RedissonClientFactory;
import org.icij.extract.redis.ResultDecoder;
import org.icij.extract.redis.ResultEncoder;
import org.icij.extract.report.Report;
import org.icij.extract.report.ReportMap;
import org.icij.task.Options;
import org.icij.task.annotation.Option;
import org.icij.task.annotation.OptionsClass;
import org.redisson.Redisson;
import org.redisson.RedissonMap;
import org.redisson.api.RedissonClient;
import org.redisson.client.RedisOutOfMemoryException;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandSyncService;
import org.redisson.connection.ConnectionManager;
import org.redisson.liveobject.core.RedissonObjectBuilder;

@org.icij.task.annotation.Options(value={@Option(name="reportName", description="The name of the report, the default of which is type-dependent.", parameter="name"), @Option(name="charset", description="Set the output encoding for text and document attributes. Defaults to UTF-8.", parameter="name")})
@OptionsClass(value=ConnectionManager.class)
public class RedisReportMap
extends RedissonMap<Path, Report>
implements ReportMap {
    private static final String DEFAULT_NAME = "extract:report";
    private final RedissonClient redissonClient;
    private final boolean shouldShutdownRedisson;

    public RedisReportMap(final String mapName, final String redisAddress) {
        this(Options.from((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("reportName", mapName);
                this.put("redisAddress", redisAddress);
                this.put("charset", "UTF-8");
            }
        }));
    }

    public RedisReportMap(Options<String> options) {
        this(new RedissonClientFactory().withOptions(options).create(), options.get("reportName").value().orElse(DEFAULT_NAME), options.get("charset").parse().asCharset().orElse(StandardCharsets.UTF_8), true);
    }

    protected RedisReportMap(RedissonClient redissonClient, String name, Charset charset) {
        this(redissonClient, name, charset, false);
    }

    protected RedisReportMap(RedissonClient redissonClient, String name, Charset charset, boolean shouldShutdownRedisson) {
        super((Codec)new ReportCodec(charset), (CommandAsyncExecutor)new CommandSyncService(((Redisson)redissonClient).getConnectionManager(), new RedissonObjectBuilder(redissonClient)), null == name ? DEFAULT_NAME : name, redissonClient, null, null);
        this.redissonClient = redissonClient;
        this.shouldShutdownRedisson = shouldShutdownRedisson;
    }

    @Override
    public Collection<Class<? extends Exception>> journalableExceptions() {
        return Collections.singletonList(RedisOutOfMemoryException.class);
    }

    @Override
    public void close() throws IOException {
        if (this.shouldShutdownRedisson) {
            this.redissonClient.shutdown();
        }
    }

    static class ReportCodec
    extends BaseCodec {
        private final Decoder<Object> documentDecoder;
        private final Encoder documentEncoder;
        private final Decoder<Object> resultDecoder = new ResultDecoder();
        private final Encoder resultEncoder = new ResultEncoder();

        ReportCodec(Charset charset) {
            this.documentDecoder = new PathDecoder(charset);
            this.documentEncoder = new PathEncoder(charset);
        }

        public Decoder<Object> getMapKeyDecoder() {
            return this.documentDecoder;
        }

        public Decoder<Object> getMapValueDecoder() {
            return this.resultDecoder;
        }

        public Encoder getMapValueEncoder() {
            return this.resultEncoder;
        }

        public Encoder getMapKeyEncoder() {
            return this.documentEncoder;
        }

        public Decoder<Object> getValueDecoder() {
            return this.resultDecoder;
        }

        public Encoder getValueEncoder() {
            return this.resultEncoder;
        }
    }
}

