/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.redis;

import java.net.URI;
import java.util.Optional;
import org.icij.task.Options;
import org.icij.task.annotation.Option;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;

@org.icij.task.annotation.Options(value={@Option(name="redisAddress", description="Set the Redis backend address. Defaults to 127.0.0.1:6379.", parameter="address"), @Option(name="redisPoolSize", description="Set the Redis backend pool size per collection.", parameter="poolSize"), @Option(name="redisTimeout", description="The client timeout for Redis operations.", parameter="timeout")})
public class RedissonClientFactory {
    private String address = null;
    private int timeout = -1;
    private int poolSize = 1;

    public RedissonClientFactory withOptions(Options<String> options) {
        this.withAddress(options.valueIfPresent("redisAddress").orElse(null));
        options.ifPresent("redisTimeout", o -> o.parse().asInteger()).ifPresent(this::withTimeout);
        options.ifPresent("redisPoolSize", o -> o.parse().asInteger()).ifPresent(this::withPoolSize);
        return this;
    }

    private RedissonClientFactory withPoolSize(int poolSize) {
        this.poolSize = poolSize;
        return this;
    }

    private RedissonClientFactory withAddress(String address) {
        this.address = address;
        return this;
    }

    private RedissonClientFactory withTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public RedissonClient create() {
        Config config = this.createConfig();
        this.updateConfig(config);
        return Redisson.create((Config)config);
    }

    void updateConfig(Config config) {
        String address = null == this.address ? "redis://127.0.0.1:6379" : this.address;
        URI url = URI.create(address);
        String[] userPass = Optional.ofNullable(url.getUserInfo()).orElse("").split(":");
        int timeout = this.timeout < 0 ? 60000 : this.timeout;
        SingleServerConfig singleServerConfig = config.useSingleServer();
        singleServerConfig.setConnectionPoolSize(this.poolSize).setConnectionMinimumIdleSize(this.poolSize).setAddress(address).setTimeout(timeout);
        if (userPass.length == 2) {
            singleServerConfig.setPassword(userPass[1]);
        }
    }

    Config createConfig() {
        return new Config();
    }
}

