/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.redis;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.icij.extract.extractor.ExtractionStatus;
import org.icij.extract.report.Report;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultDecoder
implements Decoder<Object> {
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public Object decode(ByteBuf buffer, State state) {
        Report report;
        String result = new String(new char[]{(char)buffer.readByte()});
        ExtractionStatus extractionStatus = ExtractionStatus.parse(result);
        if (buffer.capacity() == 1) {
            return new Report(extractionStatus);
        }
        buffer.readByte();
        ByteBuf exceptionPayload = buffer.getBytes(0, new byte[buffer.capacity() - 2]);
        ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)new ByteBufInputStream(exceptionPayload));
        try {
            Exception ex = (Exception)objectInputStream.readObject();
            report = new Report(extractionStatus, ex);
        }
        catch (Throwable throwable) {
            try {
                try {
                    objectInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException e) {
                this.logger.warn("cannot read object : ", (Throwable)e);
                return new Report(extractionStatus, e);
            }
        }
        objectInputStream.close();
        return report;
    }
}

