/*
 * Decompiled with CFR 0.152.
 */
package org.icij.extract.report;

import java.util.Objects;
import java.util.Optional;
import org.icij.extract.extractor.ExtractionStatus;

public class Report {
    private final ExtractionStatus status;
    private final Exception exception;

    public Report(ExtractionStatus status, Exception exception) {
        this.status = status;
        this.exception = exception;
    }

    public Report(ExtractionStatus status) {
        this.status = status;
        this.exception = null;
    }

    public ExtractionStatus getStatus() {
        return this.status;
    }

    public Optional<Exception> getException() {
        return Optional.ofNullable(this.exception);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Report)) {
            return false;
        }
        Report report = (Report)o;
        if (!this.getException().isPresent()) {
            return this.status == report.status;
        }
        return report.getException().isPresent() && this.status == report.status && this.exception.getClass().equals(report.exception.getClass()) && this.exception.getMessage().equals(report.exception.getMessage());
    }

    public int hashCode() {
        return this.exception == null ? Objects.hash(new Object[]{this.status}) : Objects.hash(new Object[]{this.status, this.exception.getClass(), this.exception.getMessage()});
    }
}

