/*
 * Decompiled with CFR 0.152.
 */
package org.icij.spewer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;

public class MetadataBlockList {
    static final Charset METADATA_BLOCK_LIST_CHARSET = StandardCharsets.UTF_8;
    static final String METADATA_BLOCK_LIST_FILE = "metadata_block_list.txt";
    private final List<String> list = MetadataBlockList.load("metadata_block_list.txt", METADATA_BLOCK_LIST_CHARSET);

    public Boolean ok(String value) {
        return this.list.stream().allMatch(pattern -> {
            String globPattern = "glob:" + pattern;
            return this.ok(value, globPattern);
        });
    }

    public Boolean ok(String value, String globPattern) {
        Path valueAsPath;
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(globPattern);
        return !matcher.matches(valueAsPath = FileSystems.getDefault().getPath(value, new String[0]));
    }

    public static List<String> load(String resourceName, Charset charset) {
        URL resource = ClassLoader.getSystemClassLoader().getResource(resourceName);
        if (resource == null) {
            return new ArrayList<String>();
        }
        return MetadataBlockList.load(resource, charset);
    }

    public static List<String> load(URL resource, Charset charset) {
        List<String> list;
        block8: {
            InputStream is = resource.openStream();
            try {
                list = IOUtils.readLines((InputStream)is, (Charset)charset).stream().map(String::trim).collect(Collectors.toList());
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return new ArrayList<String>();
                }
            }
            is.close();
        }
        return list;
    }
}

